/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.delimited;

import java.io.IOException;
import java.io.Writer;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordWriter;
import org.beanio.stream.delimited.DelimitedParserConfiguration;

public class DelimitedWriter
implements RecordWriter {
    private char delim = (char)9;
    private char escapeChar = (char)92;
    private boolean escapeEnabled = true;
    private String recordTerminator;
    private Writer out;

    public DelimitedWriter(Writer out) {
        this(out, '\t');
    }

    public DelimitedWriter(Writer out, char delimiter) {
        this(out, new DelimitedParserConfiguration(delimiter));
    }

    public DelimitedWriter(Writer out, DelimitedParserConfiguration config) {
        this.out = out;
        this.delim = config.getDelimiter();
        if (config.getEscape() == null) {
            this.escapeEnabled = false;
        } else {
            this.escapeEnabled = true;
            this.escapeChar = config.getEscape().charValue();
            if (this.delim == this.escapeChar) {
                throw new IllegalArgumentException("Delimiter cannot match the escape character");
            }
        }
        this.recordTerminator = config.getRecordTerminator();
        if (this.recordTerminator == null) {
            this.recordTerminator = System.getProperty("line.separator");
        }
    }

    public void write(Object value) throws IOException, RecordIOException {
        this.write((String[])value);
    }

    public void write(String[] record) throws IOException {
        if (this.escapeEnabled) {
            int pos = 0;
            for (String field : record) {
                if (pos++ > 0) {
                    this.out.write(this.delim);
                }
                char[] cs = field.toCharArray();
                int j = cs.length;
                for (int i = 0; i < j; ++i) {
                    if (cs[i] == this.delim || cs[i] == this.escapeChar) {
                        this.out.write(this.escapeChar);
                    }
                    this.out.write(cs[i]);
                }
            }
        } else {
            int pos = 0;
            for (String field : record) {
                if (pos++ > 0) {
                    this.out.write(this.delim);
                }
                this.out.write(field);
            }
        }
        this.out.write(this.recordTerminator);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

