/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.util.Date;

public class JobParameter
implements Serializable {
    private final Object parameter;
    private final ParameterType parameterType;
    private final boolean identifying;

    public JobParameter(String parameter, boolean identifying) {
        this.parameter = parameter;
        this.parameterType = ParameterType.STRING;
        this.identifying = identifying;
    }

    public JobParameter(Long parameter, boolean identifying) {
        this.parameter = parameter;
        this.parameterType = ParameterType.LONG;
        this.identifying = identifying;
    }

    public JobParameter(Date parameter, boolean identifying) {
        this.parameter = parameter;
        this.parameterType = ParameterType.DATE;
        this.identifying = identifying;
    }

    public JobParameter(Double parameter, boolean identifying) {
        this.parameter = parameter;
        this.parameterType = ParameterType.DOUBLE;
        this.identifying = identifying;
    }

    public JobParameter(String parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.STRING;
        this.identifying = true;
    }

    public JobParameter(Long parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.LONG;
        this.identifying = true;
    }

    public JobParameter(Date parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.DATE;
        this.identifying = true;
    }

    public JobParameter(Double parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.DOUBLE;
        this.identifying = true;
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public Object getValue() {
        if (this.parameter != null && this.parameter.getClass().isInstance(Date.class)) {
            return new Date(((Date)this.parameter).getTime());
        }
        return this.parameter;
    }

    public ParameterType getType() {
        return this.parameterType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JobParameter rhs = (JobParameter)obj;
        return this.parameter == null ? rhs.parameter == null && this.parameterType == rhs.parameterType : this.parameter.equals(rhs.parameter);
    }

    public String toString() {
        return this.parameter == null ? null : (this.parameterType == ParameterType.DATE ? "" + ((Date)this.parameter).getTime() : this.parameter.toString());
    }

    public int hashCode() {
        return 7 + 21 * (this.parameter == null ? this.parameterType.hashCode() : this.parameter.hashCode());
    }

    public static enum ParameterType {
        STRING,
        DATE,
        LONG,
        DOUBLE;

    }
}

