/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxUser;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxGroupsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxGroupsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxGroupsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxGroup> getAllGroups() {
        try {
            LOG.debug("Getting all groups");
            ArrayList<BoxGroup> groups = new ArrayList<BoxGroup>();
            for (BoxGroup.Info groupInfo : BoxGroup.getAllGroups((BoxAPIConnection)this.boxConnection)) {
                groups.add(groupInfo.getResource());
            }
            return groups;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxGroup createGroup(String name) {
        try {
            LOG.debug("Creating group name=" + name);
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' can not be null");
            }
            return BoxGroup.createGroup((BoxAPIConnection)this.boxConnection, (String)name).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteGroup(String groupId) {
        try {
            LOG.debug("Deleting group(" + groupId + ")");
            if (groupId == null) {
                throw new IllegalArgumentException("Parameter 'groupId' can not be null");
            }
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            group.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxGroup.Info getGroupInfo(String groupId) {
        try {
            LOG.debug("Getting info for group(id=" + groupId + ")");
            if (groupId == null) {
                throw new IllegalArgumentException("Parameter 'groupId' can not be null");
            }
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            return group.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Collection<BoxGroupMembership.Info> getGroupMemberships(String groupId) {
        try {
            LOG.debug("Getting information about all memberships for group(id=" + groupId + ")");
            if (groupId == null) {
                throw new IllegalArgumentException("Parameter 'groupId' can not be null");
            }
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            return group.getMemberships();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxGroupMembership addGroupMembership(String groupId, String userId, BoxGroupMembership.Role role) {
        try {
            LOG.debug("Adding user(id=" + userId + ") as member to group(id=" + groupId + (role == null ? ")" : ") with role=" + role.name()));
            if (groupId == null) {
                throw new IllegalArgumentException("Parameter 'groupId' can not be null");
            }
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return group.addMembership(user, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteGroupMembership(String groupMembershipId) {
        try {
            LOG.debug("Deleting groupMembership(id=" + groupMembershipId + ")");
            if (groupMembershipId == null) {
                throw new IllegalArgumentException("Parameter 'groupMemebershipId' can not be null");
            }
            BoxGroupMembership groupMembership = new BoxGroupMembership(this.boxConnection, groupMembershipId);
            groupMembership.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxGroupMembership.Info getGroupMembershipInfo(String groupMemebershipId) {
        try {
            LOG.debug("Getting info for groupMemebership(id=" + groupMemebershipId + ")");
            if (groupMemebershipId == null) {
                throw new IllegalArgumentException("Parameter 'groupMemebershipId' can not be null");
            }
            BoxGroupMembership group = new BoxGroupMembership(this.boxConnection, groupMemebershipId);
            return group.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxGroupMembership updateGroupMembershipInfo(String groupMemebershipId, BoxGroupMembership.Info info) {
        try {
            LOG.debug("Updating info for groupMembership(id=" + groupMemebershipId + ")");
            if (groupMemebershipId == null) {
                throw new IllegalArgumentException("Parameter 'groupMemebershipId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxGroupMembership groupMembership = new BoxGroupMembership(this.boxConnection, groupMemebershipId);
            groupMembership.updateInfo(info);
            return groupMembership;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

