/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.http.HttpResponse;
import org.lightcouch.CouchDbException;

final class CouchDbUtil {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private CouchDbUtil() {
    }

    public static void assertNotEmpty(Object object, String prefix) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s may not be null.", prefix));
        }
        if (object instanceof String && ((String)object).length() == 0) {
            throw new IllegalArgumentException(String.format("%s may not be empty.", prefix));
        }
    }

    public static void assertNull(Object object, String prefix) throws IllegalArgumentException {
        if (object != null) {
            throw new IllegalArgumentException(String.format("%s should be null.", prefix));
        }
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static <T> T JsonToObject(Gson gson, JsonElement elem, String key, Class<T> classType) {
        return (T)gson.fromJson(elem.getAsJsonObject().get(key), classType);
    }

    public static String getAsString(JsonObject j, String e) {
        return j.get(e) == null || j.get(e).isJsonNull() ? null : j.get(e).getAsString();
    }

    public static long getAsLong(JsonObject j, String e) {
        return j.get(e) == null || j.get(e).isJsonNull() ? 0L : j.get(e).getAsLong();
    }

    public static int getAsInt(JsonObject j, String e) {
        return j.get(e) == null || j.get(e).isJsonNull() ? 0 : j.get(e).getAsInt();
    }

    public static List<String> listResources(String path) {
        try {
            Class<CouchDbUtil> clazz = CouchDbUtil.class;
            URL dirURL = clazz.getClassLoader().getResource(path);
            if (dirURL != null && dirURL.getProtocol().equals("file")) {
                return Arrays.asList(new File(dirURL.toURI()).list());
            }
            if (dirURL != null && dirURL.getProtocol().equals("jar")) {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path)) continue;
                    String entry = name.substring(path.length());
                    int checkSubdir = entry.indexOf("/");
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    if (entry.length() <= 0) continue;
                    result.add(entry);
                }
                CouchDbUtil.close(jar);
                return new ArrayList<String>(result);
            }
            return null;
        }
        catch (Exception e) {
            throw new CouchDbException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) {
        InputStream instream = CouchDbUtil.class.getResourceAsStream(path);
        StringBuilder content = new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner(instream);
            while (scanner.hasNextLine()) {
                content.append(scanner.nextLine() + LINE_SEP);
            }
        }
        finally {
            scanner.close();
        }
        return content.toString();
    }

    public static InputStream getStream(HttpResponse response) {
        try {
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new CouchDbException("Error reading response. ", e);
        }
    }

    public static String removeExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String streamToString(InputStream in) {
        Scanner s = new Scanner(in);
        s.useDelimiter("\\A");
        String str = s.hasNext() ? s.next() : null;
        CouchDbUtil.close(in);
        CouchDbUtil.close(s);
        return str;
    }

    public static void close(HttpResponse response) {
        try {
            CouchDbUtil.close(response.getEntity().getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

