/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.lightcouch.Params;

class URIBuilder {
    private String scheme;
    private String host;
    private int port;
    private String path = "";
    private final StringBuilder query = new StringBuilder();
    private final List<String> qParams = new ArrayList<String>();
    private boolean uriEncoded = false;

    URIBuilder() {
    }

    public static URIBuilder buildUri() {
        return new URIBuilder();
    }

    public static URIBuilder buildUri(URI uri) {
        URIBuilder builder = URIBuilder.buildUri().scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).path(uri.getPath());
        return builder;
    }

    public URI build() {
        this.prepareQuery();
        if (this.uriEncoded) {
            return this.createUriEncoded();
        }
        return this.createUri();
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder path(String path) {
        this.path = this.path + path;
        return this;
    }

    public URIBuilder path(String path, boolean encode) {
        if (encode) {
            this.uriEncoded = true;
            try {
                this.path = this.path + URLEncoder.encode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.path(path);
        }
        return this;
    }

    public URIBuilder query(String name, Object value) {
        if (name != null && value != null) {
            this.qParams.add(String.format("%s=%s", name, value));
        }
        return this;
    }

    public URIBuilder query(String query) {
        if (query != null) {
            this.query.append(query);
        }
        return this;
    }

    public URIBuilder query(Params params) {
        if (params.getParams() != null) {
            this.qParams.addAll(params.getParams());
        }
        return this;
    }

    private URI createUri() {
        try {
            String q = this.query.length() == 0 ? null : this.query.toString();
            return new URI(this.scheme, null, this.host, this.port, this.path, q, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private URI createUriEncoded() {
        try {
            String q = this.query.length() == 0 ? "" : "?" + this.query;
            String uri = String.format("%s://%s:%s%s%s", this.scheme, this.host, this.port, this.path, q);
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void prepareQuery() {
        for (int i = 0; i < this.qParams.size(); ++i) {
            String amp = i != this.qParams.size() - 1 ? "&" : "";
            this.query.append(this.qParams.get(i) + amp);
        }
    }
}

