/*
 * Decompiled with CFR 0.152.
 */
package org.boon.messages;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageUtils {
    public static final String TOOL_TIP = "toolTip";
    public static final String LABEL_TOOL_TIP = "labelToolTip";

    private MessageUtils() {
    }

    public static String createLabelNoPlural(String fieldName, ResourceBundle bundle) {
        if (fieldName.endsWith("es")) {
            fieldName = fieldName.substring(0, fieldName.length() - 2);
        } else if (fieldName.endsWith("s")) {
            fieldName = fieldName.substring(0, fieldName.length() - 1);
        }
        return MessageUtils.getLabel(fieldName, bundle);
    }

    public static String getLabel(String fieldName, ResourceBundle bundle) {
        String label;
        try {
            label = bundle.getString(fieldName);
        }
        catch (MissingResourceException mre) {
            label = MessageUtils.generateLabelValue(fieldName);
        }
        return label;
    }

    public static String createLabelWithNameSpace(String namespace, String fieldName, ResourceBundle bundle) {
        String label;
        try {
            try {
                label = bundle.getString(namespace + '.' + fieldName);
            }
            catch (MissingResourceException mre) {
                label = bundle.getString(fieldName);
            }
        }
        catch (MissingResourceException mre) {
            label = MessageUtils.generateLabelValue(fieldName);
        }
        return label;
    }

    public static String createToolTipWithNameSpace(String namespace, String fieldName, ResourceBundle bundle, String toolTipType) {
        String toolTip = null;
        try {
            try {
                toolTip = bundle.getString(namespace + '.' + fieldName + '.' + toolTipType);
            }
            catch (MissingResourceException mre) {
                toolTip = bundle.getString(fieldName + '.' + toolTipType);
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return toolTip;
    }

    public static String generateLabelValue(final String fieldName) {
        final StringBuilder buffer = new StringBuilder(fieldName.length() * 2);
        class GenerationCommand {
            boolean capNextChar = false;
            boolean lastCharWasUpperCase = false;
            boolean lastCharWasNumber = false;
            boolean lastCharWasSpecial = false;
            boolean shouldContinue = true;
            char[] chars = fieldName.toCharArray();

            GenerationCommand() {
            }

            void processFieldName() {
                for (int index = 0; index < this.chars.length; ++index) {
                    char cchar = this.chars[index];
                    this.shouldContinue = true;
                    this.processCharWasNumber(buffer, index, cchar);
                    if (!this.shouldContinue) continue;
                    this.processCharWasUpperCase(buffer, index, cchar);
                    if (!this.shouldContinue) continue;
                    this.processSpecialChars(buffer, cchar);
                    if (!this.shouldContinue) continue;
                    cchar = this.processCapitalizeCommand(cchar);
                    cchar = this.processFirstCharacterCheck(buffer, index, cchar);
                    if (!this.shouldContinue) continue;
                    buffer.append(cchar);
                }
            }

            private void processCharWasNumber(StringBuilder buffer2, int index, char cchar) {
                if (this.lastCharWasSpecial) {
                    return;
                }
                if (Character.isDigit(cchar)) {
                    if (index != 0 && !this.lastCharWasNumber) {
                        buffer2.append(' ');
                    }
                    this.lastCharWasNumber = true;
                    buffer2.append(cchar);
                    this.shouldContinue = false;
                } else {
                    this.lastCharWasNumber = false;
                }
            }

            private char processFirstCharacterCheck(StringBuilder buffer2, int index, char cchar) {
                if (index == 0) {
                    cchar = Character.toUpperCase(cchar);
                    buffer2.append(cchar);
                    this.shouldContinue = false;
                }
                return cchar;
            }

            private char processCapitalizeCommand(char cchar) {
                if (this.capNextChar) {
                    this.capNextChar = false;
                    cchar = Character.toUpperCase(cchar);
                }
                return cchar;
            }

            private void processSpecialChars(StringBuilder buffer2, char cchar) {
                this.lastCharWasSpecial = false;
                if (cchar == '.' || cchar == '_') {
                    buffer2.append(' ');
                    this.capNextChar = true;
                    this.lastCharWasSpecial = false;
                    this.shouldContinue = false;
                }
            }

            private void processCharWasUpperCase(StringBuilder buffer2, int index, char cchar) {
                if (Character.isUpperCase(cchar)) {
                    if (index != 0 && !this.lastCharWasUpperCase) {
                        buffer2.append(' ');
                    }
                    this.lastCharWasUpperCase = true;
                    buffer2.append(cchar);
                    this.shouldContinue = false;
                } else {
                    this.lastCharWasUpperCase = false;
                }
            }
        }
        GenerationCommand gc = new GenerationCommand();
        gc.processFieldName();
        return buffer.toString().replace("  ", " ");
    }
}

