/*
 * Decompiled with CFR 0.152.
 */
package org.boon.sort;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.sort.Sorting;

public class SortingInternal {
    public static void sort(List list, String sortBy, Map<String, FieldAccess> fields, boolean ascending) {
        SortingInternal.sort(list, sortBy, fields, ascending, false);
    }

    public static void sort(List list, String sortBy, Map<String, FieldAccess> fields, boolean ascending, boolean nullsFirst) {
        try {
            if (list == null || list.size() == 0) {
                return;
            }
            Object o = list.get(0);
            if (sortBy.equals("this")) {
                Collections.sort(list, Sorting.thisUniversalComparator(ascending, nullsFirst));
                return;
            }
            FieldAccess field = fields.get(sortBy);
            if (field != null) {
                Collections.sort(list, Sorting.universalComparator(field, ascending, nullsFirst));
            }
        }
        catch (Exception ex) {
            Exceptions.handle(ex, "list", list, "\nsortBy", sortBy, "fields", fields, "ascending", ascending, "nullFirst", nullsFirst);
        }
    }
}

