/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.Maps;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.validation.FieldValidator;
import org.boon.validation.ValidationContext;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.ValidatorMetaData;
import org.boon.validation.ValidatorMetaDataReader;
import org.boon.validation.readers.AnnotationValidatorMetaDataReader;
import org.boon.validation.validators.CompositeValidator;

public class RecursiveDescentPropertyValidator {
    protected ValidatorMetaDataReader validatorMetaDataReader = new AnnotationValidatorMetaDataReader();

    protected CompositeValidator createValidator(List<ValidatorMetaData> validationMetaDataList) {
        CompositeValidator compositeValidator = new CompositeValidator();
        List<FieldValidator> validatorsList = this.lookupTheListOfValidatorsAndInitializeThemWithMetaDataProperties(validationMetaDataList);
        compositeValidator.setValidatorList(validatorsList);
        return compositeValidator;
    }

    private List<PropertyDescriptor> getFieldsToValidate(Object object) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(propertyDescriptors.length);
        for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.getName().equals("class")) continue;
            properties.add(pd);
        }
        return properties;
    }

    protected List<ValidatorMetaData> readMetaData(Class<?> clazz, String propertyName) {
        return this.validatorMetaDataReader.readMetaData(clazz, propertyName);
    }

    private void validateProperty(Object object, Object objectProperty, String property, List<MessageHolder> vMessageHolders) {
        List<ValidatorMetaData> metaDataList = this.readMetaData(object.getClass(), property);
        CompositeValidator cv = this.createValidator(metaDataList);
        ValidatorMessageHolder holder = cv.validate(objectProperty, property);
        vMessageHolders.add(new MessageHolder(ValidationContext.getBindingPath(), holder));
    }

    protected boolean shouldFieldBeValidated() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageHolder> validateObject(Object object) {
        List<MessageHolder> list = Collections.EMPTY_LIST;
        try {
            ValidationContext.create();
            list = this.validateObjectWithMessages(object, null);
        }
        finally {
            ValidationContext.destroy();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageHolder> validateObject(Object object, Map<String, Object> registry) {
        List<MessageHolder> list = Collections.EMPTY_LIST;
        try {
            ValidationContext.create();
            ValidationContext.get().setObjectRegistry(registry);
            list = this.validateObjectWithMessages(object, null);
        }
        finally {
            ValidationContext.destroy();
        }
        return list;
    }

    public List<MessageHolder> validateObjectWithMessages(Object object, List<MessageHolder> validationMessages) {
        List<PropertyDescriptor> fieldsToValidate = this.getFieldsToValidate(object);
        Map<String, Object> objectPropertiesAsMap = Maps.toMap(object);
        if (validationMessages == null) {
            validationMessages = new ArrayList<MessageHolder>();
        }
        for (PropertyDescriptor field : fieldsToValidate) {
            ValidationContext.get().pushProperty(field.getName());
            ValidationContext.get().setParentObject(object);
            if (this.shouldFieldBeValidated()) {
                Object propertyObject = objectPropertiesAsMap.get(field.getName());
                this.validateProperty(object, propertyObject, field.getName(), validationMessages);
                if (propertyObject != null && !Typ.isBasicType(propertyObject)) {
                    this.validateObjectWithMessages(propertyObject, validationMessages);
                }
            }
            ValidationContext.get().pop();
        }
        return validationMessages;
    }

    private List<FieldValidator> lookupTheListOfValidatorsAndInitializeThemWithMetaDataProperties(List<ValidatorMetaData> validationMetaDataList) {
        ArrayList<FieldValidator> validatorsList = new ArrayList<FieldValidator>();
        for (ValidatorMetaData validationMetaData : validationMetaDataList) {
            FieldValidator validator = this.lookupValidatorInRegistry(validationMetaData.getName());
            this.applyValidationMetaDataPropertiesToValidator(validationMetaData, validator);
            validatorsList.add(validator);
        }
        return validatorsList;
    }

    private FieldValidator lookupValidatorInRegistry(String validationMetaDataName) {
        Map<String, Object> applicationContext = ValidationContext.get().getObjectRegistry();
        Exceptions.requireNonNull(applicationContext);
        return (FieldValidator)applicationContext.get("/org/boon/validator/" + validationMetaDataName);
    }

    private void applyValidationMetaDataPropertiesToValidator(ValidatorMetaData metaData, FieldValidator validator) {
        Map<String, Object> properties = metaData.getProperties();
        this.ifPropertyBlankRemove(properties, "detailMessage");
        this.ifPropertyBlankRemove(properties, "summaryMessage");
        BeanUtils.copyProperties((Object)validator, properties);
    }

    private void ifPropertyBlankRemove(Map<String, Object> properties, String property) {
        String string;
        Object object = properties.get(property);
        if (object == null) {
            properties.remove(property);
        } else if (object instanceof String && "".equals((string = (String)object).trim())) {
            properties.remove(property);
        }
    }

    public void setValidatorMetaDataReader(ValidatorMetaDataReader validatorMetaDataReader) {
        this.validatorMetaDataReader = validatorMetaDataReader;
    }

    public class MessageHolder {
        public final String propertyPath;
        public final ValidatorMessageHolder holder;

        MessageHolder(String propertyPath, ValidatorMessageHolder holder) {
            this.propertyPath = propertyPath;
            this.holder = holder;
        }
    }
}

