/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public final class GlobalOrdinalsBuilder
extends Enum<GlobalOrdinalsBuilder> {
    private static final /* synthetic */ GlobalOrdinalsBuilder[] $VALUES;

    public static GlobalOrdinalsBuilder[] values() {
        return (GlobalOrdinalsBuilder[])$VALUES.clone();
    }

    public static GlobalOrdinalsBuilder valueOf(String name) {
        return Enum.valueOf(GlobalOrdinalsBuilder.class, name);
    }

    public static IndexOrdinalsFieldData build(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, Settings settings, CircuitBreakerService breakerService, ESLogger logger) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        AtomicOrdinalsFieldData[] atomicFD = new AtomicOrdinalsFieldData[indexReader.leaves().size()];
        RandomAccessOrds[] subs = new RandomAccessOrds[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = (AtomicOrdinalsFieldData)indexFieldData.load((LeafReaderContext)indexReader.leaves().get(i));
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, (SortedSetDocValues[])subs, (float)0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breakerService.getBreaker("fielddata").addWithoutBreaking(memorySizeInBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("Global-ordinals[{}][{}] took {} ms", indexFieldData.getFieldNames().fullName(), ordinalMap.getValueCount(), TimeValue.nsecToMSec(System.nanoTime() - startTimeNS));
        }
        return new InternalGlobalOrdinalsIndexFieldData(indexFieldData.index(), settings, indexFieldData.getFieldNames(), indexFieldData.getFieldDataType(), atomicFD, ordinalMap, memorySizeInBytes);
    }

    public static IndexOrdinalsFieldData buildEmpty(Index index, Settings settings, IndexReader indexReader, IndexOrdinalsFieldData indexFieldData) throws IOException {
        assert (indexReader.leaves().size() > 1);
        AtomicOrdinalsFieldData[] atomicFD = new AtomicOrdinalsFieldData[indexReader.leaves().size()];
        RandomAccessOrds[] subs = new RandomAccessOrds[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = new AbstractAtomicOrdinalsFieldData(){

                @Override
                public RandomAccessOrds getOrdinalsValues() {
                    return DocValues.emptySortedSet();
                }

                public long ramBytesUsed() {
                    return 0L;
                }

                public Collection<Accountable> getChildResources() {
                    return Collections.emptyList();
                }

                @Override
                public void close() {
                }
            };
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, (SortedSetDocValues[])subs, (float)0.25f);
        return new InternalGlobalOrdinalsIndexFieldData(index, settings, indexFieldData.getFieldNames(), indexFieldData.getFieldDataType(), atomicFD, ordinalMap, 0L);
    }

    static {
        $VALUES = new GlobalOrdinalsBuilder[0];
    }
}

