/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.XUsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.ShardBitsetFilterCache;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.IndexSearcherWrappingService;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchStats;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ElasticsearchQueryCachingPolicy;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.MergePolicyConfig;
import org.elasticsearch.index.shard.MergeSchedulerConfig;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetaData;
import org.elasticsearch.index.shard.StoreRecoveryService;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.suggest.stats.ShardSuggestMetric;
import org.elasticsearch.index.suggest.stats.SuggestStats;
import org.elasticsearch.index.termvectors.ShardTermVectorsService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShard
extends AbstractIndexShardComponent {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final IndexAliasesService indexAliasesService;
    private final ShardIndexingService indexingService;
    private final ShardSearchStats searchService;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache shardQueryCache;
    private final ShardFieldData shardFieldData;
    private final PercolatorQueriesRegistry percolatorQueriesRegistry;
    private final ShardPercolateService shardPercolateService;
    private final ShardTermVectorsService termVectorsService;
    private final IndexFieldDataService indexFieldDataService;
    private final IndexService indexService;
    private final ShardSuggestMetric shardSuggestMetric = new ShardSuggestMetric();
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final DiscoveryNode localNode;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final IndicesWarmer warmer;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final SimilarityService similarityService;
    private final EngineConfig engineConfig;
    private final TranslogConfig translogConfig;
    private final MergePolicyConfig mergePolicyConfig;
    private final IndicesQueryCache indicesQueryCache;
    private final StoreRecoveryService storeRecoveryService;
    private TimeValue refreshInterval;
    private volatile ScheduledFuture<?> refreshScheduledFuture;
    private volatile ScheduledFuture<?> mergeScheduleFuture;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    protected final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    protected final EngineFactory engineFactory;
    private final IndexSearcherWrappingService wrappingService;
    @Nullable
    private RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final ShardEngineFailListener failedEngineListener = new ShardEngineFailListener();
    private volatile boolean flushOnClose = true;
    public static final String INDEX_FLUSH_ON_CLOSE = "index.flush_on_close";
    private final ShardPath path;
    private final IndexShardOperationCounter indexShardOperationCounter;
    private EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.RELOCATED, IndexShardState.POST_RECOVERY);
    private final AtomicBoolean active = new AtomicBoolean();
    private volatile long lastWriteNS;
    private final IndexingMemoryController indexingMemoryController;
    public static final String INDEX_REFRESH_INTERVAL = "index.refresh_interval";

    @Inject
    public IndexShard(ShardId shardId, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, StoreRecoveryService storeRecoveryService, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService, IndicesQueryCache indicesQueryCache, ShardPercolateService shardPercolateService, CodecService codecService, ShardTermVectorsService termVectorsService, IndexFieldDataService indexFieldDataService, IndexService indexService, @Nullable IndicesWarmer warmer, SnapshotDeletionPolicy deletionPolicy, SimilarityService similarityService, EngineFactory factory, ClusterService clusterService, ShardPath path, BigArrays bigArrays, IndexSearcherWrappingService wrappingService, IndexingMemoryController indexingMemoryController) {
        super(shardId, indexSettingsService.getSettings());
        QueryCachingPolicy cachingPolicy;
        this.codecService = codecService;
        this.warmer = warmer;
        this.deletionPolicy = deletionPolicy;
        this.similarityService = similarityService;
        this.wrappingService = wrappingService;
        Preconditions.checkNotNull((Object)store, (Object)"Store must be provided to the index shard");
        Preconditions.checkNotNull((Object)deletionPolicy, (Object)"Snapshot deletion policy must be provided to the index shard");
        this.engineFactory = factory;
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.storeRecoveryService = storeRecoveryService;
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this.indexSettings);
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.indexingService = new ShardIndexingService(shardId, this.indexSettings);
        this.getService = new ShardGetService(this, mapperService);
        this.termVectorsService = termVectorsService.setIndexShard(this);
        this.searchService = new ShardSearchStats(this.indexSettings);
        this.shardWarmerService = new ShardIndexWarmerService(shardId, this.indexSettings);
        this.indicesQueryCache = indicesQueryCache;
        this.shardQueryCache = new ShardRequestCache(shardId, this.indexSettings);
        this.shardFieldData = new ShardFieldData();
        this.percolatorQueriesRegistry = new PercolatorQueriesRegistry(shardId, this.indexSettings, queryParserService, this.indexingService, indicesLifecycle, mapperService, indexFieldDataService, shardPercolateService);
        this.shardPercolateService = shardPercolateService;
        this.indexFieldDataService = indexFieldDataService;
        this.indexService = indexService;
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(shardId, this.indexSettings);
        assert (clusterService.localNode() != null) : "Local node is null lifecycle state is: " + (Object)((Object)clusterService.lifecycleState());
        this.localNode = clusterService.localNode();
        this.state = IndexShardState.CREATED;
        this.refreshInterval = this.indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, EngineConfig.DEFAULT_REFRESH_INTERVAL);
        this.flushOnClose = this.indexSettings.getAsBoolean(INDEX_FLUSH_ON_CLOSE, (Boolean)true);
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.path = path;
        this.mergePolicyConfig = new MergePolicyConfig(this.logger, this.indexSettings);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndexOnStartup = this.indexSettings.get("index.shard.check_on_startup", "false");
        this.translogConfig = new TranslogConfig(shardId, this.shardPath().resolveTranslog(), this.indexSettings, IndexShard.getFromSettings(this.logger, this.indexSettings, Translog.Durabilty.REQUEST), bigArrays, threadPool);
        if (this.indexSettings.getAsBoolean("index.queries.cache.everything", (Boolean)false).booleanValue()) {
            cachingPolicy = QueryCachingPolicy.ALWAYS_CACHE;
        } else {
            Object policy = new XUsageTrackingQueryCachingPolicy();
            if (!this.indexSettings.getAsBoolean("index.queries.cache.term_queries", (Boolean)true).booleanValue()) {
                policy = new ElasticsearchQueryCachingPolicy((QueryCachingPolicy)policy);
            }
            cachingPolicy = policy;
        }
        this.engineConfig = this.newEngineConfig(this.translogConfig, cachingPolicy);
        this.indexShardOperationCounter = new IndexShardOperationCounter(this.logger, shardId);
        this.indexingMemoryController = indexingMemoryController;
        this.active.set(false);
    }

    public Store store() {
        return this.store;
    }

    public boolean canIndex() {
        return true;
    }

    public ShardIndexingService indexingService() {
        return this.indexingService;
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardTermVectorsService termVectorsService() {
        return this.termVectorsService;
    }

    public ShardSuggestMetric getSuggestMetric() {
        return this.shardSuggestMetric;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public IndexFieldDataService indexFieldDataService() {
        return this.indexFieldDataService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexService indexService() {
        return this.indexService;
    }

    public ShardSearchStats searchService() {
        return this.searchService;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.shardQueryCache;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.engineConfig.getQueryCachingPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRoutingEntry(ShardRouting newRouting, boolean persistState) {
        ShardRouting currentRouting = this.shardRouting;
        if (!newRouting.shardId().equals(this.shardId())) {
            throw new IllegalArgumentException("Trying to set a routing entry with shardId [" + newRouting.shardId() + "] on a shard with" + " shardId [" + this.shardId() + "]");
        }
        if (!(currentRouting == null || newRouting.isSameAllocation(currentRouting))) {
            throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + currentRouting + ", new " + newRouting);
        }
        try {
            if (currentRouting != null) {
                if (!newRouting.primary() && currentRouting.primary()) {
                    this.logger.warn("suspect illegal state: trying to move shard from primary mode to replica mode", new Object[0]);
                }
                if (currentRouting.equalsIgnoringMetaData(newRouting)) {
                    this.shardRouting = newRouting;
                    return;
                }
            }
            if (this.state == IndexShardState.POST_RECOVERY && (newRouting.state() == ShardRoutingState.STARTED || newRouting.state() == ShardRoutingState.RELOCATING)) {
                try {
                    this.engine().refresh("cluster_state_started");
                }
                catch (Throwable t) {
                    this.logger.debug("failed to refresh due to move to cluster wide started", t, new Object[0]);
                }
                boolean movedToStarted = false;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.state == IndexShardState.POST_RECOVERY) {
                        this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
                        movedToStarted = true;
                    } else {
                        this.logger.debug("state [{}] not changed, not in POST_RECOVERY, global state is [{}]", new Object[]{this.state, newRouting.state()});
                    }
                }
                if (movedToStarted) {
                    this.indicesLifecycle.afterIndexShardStarted(this);
                }
            }
            this.shardRouting = newRouting;
            this.indicesLifecycle.shardRoutingChanged(this, currentRouting, newRouting);
        }
        finally {
            if (persistState) {
                this.persistMetadata(newRouting, currentRouting);
            }
        }
    }

    public IndexShardState recovering(String reason, RecoveryState.Type type, DiscoveryNode sourceNode) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        return this.recovering(reason, new RecoveryState(this.shardId, this.shardRouting.primary(), type, sourceNode, this.localNode));
    }

    public IndexShardState recovering(String reason, RecoveryState.Type type, RestoreSource restoreSource) throws IndexShardStartedException {
        return this.recovering(reason, new RecoveryState(this.shardId, this.shardRouting.primary(), type, restoreSource, this.localNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexShardState recovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard relocated(String reason) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.changeState(IndexShardState.RELOCATED, reason);
        }
        return this;
    }

    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, newState, reason});
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indicesLifecycle.indexShardStateChanged(this, previousState, reason);
        return previousState;
    }

    public Engine.Create prepareCreateOnPrimary(SourceToParse source, long version, VersionType versionType, boolean canHaveDuplicates, boolean autoGeneratedId) {
        try {
            if (!this.shardRouting.primary()) {
                throw new IllegalIndexShardStateException(this.shardId, this.state, "shard is not a primary");
            }
            return IndexShard.prepareCreate(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.PRIMARY, this.state != IndexShardState.STARTED || canHaveDuplicates, autoGeneratedId);
        }
        catch (Throwable t) {
            this.verifyNotClosed(t);
            throw t;
        }
    }

    public Engine.Create prepareCreateOnReplica(SourceToParse source, long version, VersionType versionType, boolean canHaveDuplicates, boolean autoGeneratedId) {
        try {
            return IndexShard.prepareCreate(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.REPLICA, this.state != IndexShardState.STARTED || canHaveDuplicates, autoGeneratedId);
        }
        catch (Throwable t) {
            this.verifyNotClosed(t);
            throw t;
        }
    }

    static Engine.Create prepareCreate(DocumentMapperForType docMapper, SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates, boolean autoGeneratedId) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        return new Engine.Create(docMapper.getDocumentMapper().uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, canHaveDuplicates, autoGeneratedId);
    }

    public void create(Engine.Create create) {
        this.ensureWriteAllowed(create);
        this.markLastWrite();
        create = this.indexingService.preCreate(create);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}]{}", create.type(), create.id(), create.docs());
            }
            this.engine().create(create);
            create.endTime(System.nanoTime());
        }
        catch (Throwable ex) {
            this.indexingService.postCreate(create, ex);
            throw ex;
        }
        this.indexingService.postCreate(create);
    }

    public Engine.Index prepareIndexOnPrimary(SourceToParse source, long version, VersionType versionType, boolean canHaveDuplicates) {
        try {
            if (!this.shardRouting.primary()) {
                throw new IllegalIndexShardStateException(this.shardId, this.state, "shard is not a primary");
            }
            return IndexShard.prepareIndex(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.PRIMARY, this.state != IndexShardState.STARTED || canHaveDuplicates);
        }
        catch (Throwable t) {
            this.verifyNotClosed(t);
            throw t;
        }
    }

    public Engine.Index prepareIndexOnReplica(SourceToParse source, long version, VersionType versionType, boolean canHaveDuplicates) {
        try {
            return IndexShard.prepareIndex(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.REPLICA, this.state != IndexShardState.STARTED || canHaveDuplicates);
        }
        catch (Throwable t) {
            this.verifyNotClosed(t);
            throw t;
        }
    }

    static Engine.Index prepareIndex(DocumentMapperForType docMapper, SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        return new Engine.Index(docMapper.getDocumentMapper().uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, canHaveDuplicates);
    }

    public boolean index(Engine.Index index) {
        boolean created;
        this.ensureWriteAllowed(index);
        this.markLastWrite();
        index = this.indexingService.preIndex(index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}]{}", index.type(), index.id(), index.docs());
            }
            created = this.engine().index(index);
            index.endTime(System.nanoTime());
        }
        catch (Throwable ex) {
            this.indexingService.postIndex(index, ex);
            throw ex;
        }
        this.indexingService.postIndex(index, created);
        return created;
    }

    public Engine.Delete prepareDeleteOnPrimary(String type, String id, long version, VersionType versionType) {
        if (!this.shardRouting.primary()) {
            throw new IllegalIndexShardStateException(this.shardId, this.state, "shard is not a primary");
        }
        DocumentMapper documentMapper = this.docMapper(type).getDocumentMapper();
        return IndexShard.prepareDelete(type, id, documentMapper.uidMapper().term(Uid.createUid(type, id)), version, versionType, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.Delete prepareDeleteOnReplica(String type, String id, long version, VersionType versionType) {
        DocumentMapper documentMapper = this.docMapper(type).getDocumentMapper();
        return IndexShard.prepareDelete(type, id, documentMapper.uidMapper().term(Uid.createUid(type, id)), version, versionType, Engine.Operation.Origin.REPLICA);
    }

    static Engine.Delete prepareDelete(String type, String id, Term uid, long version, VersionType versionType, Engine.Operation.Origin origin) {
        long startTime = System.nanoTime();
        return new Engine.Delete(type, id, uid, version, versionType, origin, startTime, false);
    }

    public void delete(Engine.Delete delete) {
        this.ensureWriteAllowed(delete);
        this.markLastWrite();
        delete = this.indexingService.preDelete(delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", delete.uid().text());
            }
            this.engine().delete(delete);
            delete.endTime(System.nanoTime());
        }
        catch (Throwable ex) {
            this.indexingService.postDelete(delete, ex);
            throw ex;
        }
        this.indexingService.postDelete(delete);
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        return this.engine().get(get);
    }

    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with source: {}", source);
        }
        long time = System.nanoTime();
        this.engine().refresh(source);
        this.refreshMetric.inc(System.nanoTime() - time);
    }

    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        try (Engine.Searcher searcher = this.acquireSearcher("doc_stats");){
            DocsStats docsStats = new DocsStats(searcher.reader().numDocs(), searcher.reader().numDeletedDocs());
            return docsStats;
        }
    }

    @Nullable
    public CommitStats commitStats() {
        Engine engine = this.engineUnsafe();
        return engine == null ? null : engine.commitStats();
    }

    public IndexingStats indexingStats(String ... types) {
        return this.indexingService.stats(types);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchService.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            throw new ElasticsearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
        catch (AlreadyClosedException ex) {
            return null;
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.engineUnsafe();
        if (engine == null) {
            return new MergeStats();
        }
        return engine.getMergeStats();
    }

    public SegmentsStats segmentStats() {
        SegmentsStats segmentsStats = this.engine().segmentsStats();
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public QueryCacheStats queryCacheStats() {
        return this.indicesQueryCache.getStats(this.shardId);
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public PercolatorQueriesRegistry percolateRegistry() {
        return this.percolatorQueriesRegistry;
    }

    public ShardPercolateService shardPercolateService() {
        return this.shardPercolateService;
    }

    public TranslogStats translogStats() {
        return this.engine().getTranslog().stats();
    }

    public SuggestStats suggestStats() {
        return this.shardSuggestMetric.stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStats completionStats(String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        try (Engine.Searcher currentSearcher = this.acquireSearcher("completion_stats");){
            Completion090PostingsFormat postingsFormat = (Completion090PostingsFormat)PostingsFormat.forName((String)"completion090");
            completionStats.add(postingsFormat.completionStats(currentSearcher.reader(), fields));
        }
        return completionStats;
    }

    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        this.verifyStartedOrRecovering();
        this.logger.trace("trying to sync flush. sync id [{}]. expected commit id [{}]]", syncId, expectedCommitId);
        return this.engine().syncFlush(syncId, expectedCommitId);
    }

    public Engine.CommitId flush(FlushRequest request) throws ElasticsearchException {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", request);
        }
        this.verifyStartedOrRecovering();
        long time = System.nanoTime();
        Engine.CommitId commitId = this.engine().flush(force, waitIfOngoing);
        this.flushMetric.inc(System.nanoTime() - time);
        return commitId;
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", forceMerge);
        }
        this.engine().forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false);
    }

    public org.apache.lucene.util.Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", upgrade);
        }
        org.apache.lucene.util.Version previousVersion = this.minimumCompatibleVersion();
        this.engine().forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments());
        org.apache.lucene.util.Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", this.shardId, previousVersion, version);
        }
        return version;
    }

    public org.apache.lucene.util.Version minimumCompatibleVersion() {
        org.apache.lucene.util.Version luceneVersion = null;
        for (Segment segment : this.engine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? Version.indexCreated((Settings)this.indexSettings).luceneVersion : luceneVersion;
    }

    public SnapshotIndexCommit snapshotIndex(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED) {
            return this.engine().snapshotIndex(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed");
    }

    public void failShard(String reason, @Nullable Throwable e) {
        this.engine().failEngine(reason, e);
    }

    public Engine.Searcher acquireSearcher(String source) {
        this.readAllowed();
        return this.engine().acquireSearcher(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.indexSettingsService.removeListener(this.applyRefreshSettings);
                if (this.state != IndexShardState.CLOSED) {
                    FutureUtils.cancel(this.refreshScheduledFuture);
                    this.refreshScheduledFuture = null;
                    FutureUtils.cancel(this.mergeScheduleFuture);
                    this.mergeScheduleFuture = null;
                }
                this.changeState(IndexShardState.CLOSED, reason);
                this.indexShardOperationCounter.decRef();
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine != null && flushEngine && this.flushOnClose) {
                        engine.flushAndClose();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.close((Closeable[])new Closeable[]{engine, this.percolatorQueriesRegistry});
                    throw throwable2;
                }
                IOUtils.close((Closeable[])new Closeable[]{engine, this.percolatorQueriesRegistry});
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            try {
                if (engine != null && flushEngine && this.flushOnClose) {
                    engine.flushAndClose();
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{engine, this.percolatorQueriesRegistry});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{engine, this.percolatorQueriesRegistry});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        this.indicesLifecycle.beforeIndexShardPostRecovery(this);
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            this.recoveryState.setStage(RecoveryState.Stage.DONE);
            this.changeState(IndexShardState.POST_RECOVERY, reason);
        }
        this.indicesLifecycle.afterIndexShardPostRecovery(this);
        return this;
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public int performBatchRecovery(Iterable<Translog.Operation> operations) {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.markLastWrite();
        return this.engineConfig.getTranslogRecoveryPerformer().performBatchRecovery(this.engine(), operations);
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.engineConfig.getIndexingBufferSize();
    }

    public Map<String, Mapping> performTranslogRecovery(boolean indexExists) {
        if (!indexExists) {
            RecoveryState.Translog translogStats = this.recoveryState().getTranslog();
            translogStats.totalOperations(0);
            translogStats.totalOperationsOnStart(0);
        }
        Map<String, Mapping> recoveredTypes = this.internalPerformTranslogRecovery(false, indexExists);
        assert (this.recoveryState.getStage() == RecoveryState.Stage.TRANSLOG) : "TRANSLOG stage expected but was: " + (Object)((Object)this.recoveryState.getStage());
        return recoveredTypes;
    }

    private Map<String, Mapping> internalPerformTranslogRecovery(boolean skipTranslogRecovery, boolean indexExists) {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        this.engineConfig.setEnableGcDeletes(false);
        this.engineConfig.setCreate(!indexExists);
        if (!skipTranslogRecovery) {
            this.markLastWrite();
        }
        this.createNewEngine(skipTranslogRecovery, this.engineConfig);
        return this.engineConfig.getTranslogRecoveryPerformer().getRecoveredTypes();
    }

    public void skipTranslogRecovery() throws IOException {
        assert (this.engineUnsafe() == null) : "engine was already created";
        Map<String, Mapping> recoveredTypes = this.internalPerformTranslogRecovery(true, true);
        assert (recoveredTypes.isEmpty());
        assert (this.recoveryState.getTranslog().recoveredOperations() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            IOUtils.close((Closeable[])new Closeable[]{engine});
            this.recoveryState().setStage(RecoveryState.Stage.INIT);
        }
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        this.engine().refresh("recovery_finalization");
        this.startScheduledTasksIfNeeded();
        this.engineConfig.setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!this.readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + this.readAllowedStates.toString());
        }
    }

    private void markLastWrite() {
        this.lastWriteNS = System.nanoTime();
        if (!this.active.getAndSet(true)) {
            this.indexingMemoryController.forceCheck();
        }
    }

    private void ensureWriteAllowed(Engine.Operation op) throws IllegalIndexShardStateException {
        Engine.Operation.Origin origin = op.origin();
        IndexShardState state = this.state;
        if (origin == Engine.Operation.Origin.PRIMARY ? state != IndexShardState.STARTED && state != IndexShardState.RELOCATED : state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering, origin [" + (Object)((Object)origin) + "]");
        }
    }

    protected final void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering");
        }
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Throwable suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IllegalIndexShardStateException exc = new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    protected final void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
    }

    public void addFailedEngineListener(Engine.FailedEngineListener failedEngineListener) {
        this.failedEngineListener.delegates.add(failedEngineListener);
    }

    public void updateBufferSize(ByteSizeValue shardIndexingBufferSize, ByteSizeValue shardTranslogBufferSize) {
        EngineConfig config = this.engineConfig;
        ByteSizeValue preValue = config.getIndexingBufferSize();
        config.setIndexingBufferSize(shardIndexingBufferSize);
        Engine engine = this.engineUnsafe();
        if (engine == null) {
            this.logger.debug("updateBufferSize: engine is closed; skipping", new Object[0]);
            return;
        }
        if (preValue.bytes() != shardIndexingBufferSize.bytes()) {
            engine.onSettingsChanged();
            long iwBytesUsed = engine.indexWriterRAMBytesUsed();
            String message = LoggerMessageFormat.format("updating index_buffer_size from [{}] to [{}]; IndexWriter now using [{}] bytes", preValue, shardIndexingBufferSize, iwBytesUsed);
            if (iwBytesUsed > shardIndexingBufferSize.bytes()) {
                this.logger.debug(message + "; now refresh to clear IndexWriter memory", new Object[0]);
                try {
                    this.refresh("update index buffer");
                }
                catch (Throwable e) {
                    this.logger.warn("failed to refresh after decreasing index buffer", e, new Object[0]);
                }
            } else {
                this.logger.debug(message, new Object[0]);
            }
        }
        engine.getTranslog().updateBuffer(shardTranslogBufferSize);
    }

    public boolean checkIdle(long inactiveTimeNS) {
        boolean wasActive;
        if (this.state == IndexShardState.RECOVERING) {
            return false;
        }
        if (System.nanoTime() - this.lastWriteNS >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.updateBufferSize(IndexingMemoryController.INACTIVE_SHARD_INDEXING_BUFFER, IndexingMemoryController.INACTIVE_SHARD_TRANSLOG_BUFFER);
            this.logger.debug("marking shard as inactive (inactive_time=[{}]) indexing wise", inactiveTimeNS);
            this.indicesLifecycle.onShardInactive(this);
        }
        return !this.active.get();
    }

    public boolean getActive() {
        return this.active.get();
    }

    public final boolean isFlushOnClose() {
        return this.flushOnClose;
    }

    public void deleteShardState() throws IOException {
        if (this.routingEntry() != null && this.routingEntry().active()) {
            throw new IllegalStateException("Can't delete shard state on an active shard");
        }
        MetaDataStateFormat.deleteMetaState(this.shardPath().getDataPath());
    }

    public ShardPath shardPath() {
        return this.path;
    }

    public void recoverFromStore(ShardRouting shard, StoreRecoveryService.RecoveryListener recoveryListener) {
        assert (shard.primary()) : "recover from store only makes sense if the shard is a primary shard";
        boolean shouldExist = shard.allocatedPostIndexCreate();
        this.storeRecoveryService.recover(this, shouldExist, recoveryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        BytesStreamOutput os;
        long timeNS;
        block27: {
            timeNS = System.nanoTime();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            os = new BytesStreamOutput();
            PrintStream out = new PrintStream((OutputStream)os, false, Charsets.UTF_8.name());
            if ("checksum".equalsIgnoreCase(this.checkIndexOnStartup)) {
                IOException corrupt = null;
                Store.MetadataSnapshot metadata = this.store.getMetadata();
                for (Map.Entry<String, StoreFileMetaData> entry : metadata.asMap().entrySet()) {
                    try {
                        Store.checkIntegrity(entry.getValue(), this.store.directory());
                        out.println("checksum passed: " + entry.getKey());
                    }
                    catch (IOException exc) {
                        out.println("checksum failed: " + entry.getKey());
                        exc.printStackTrace(out);
                        corrupt = exc;
                    }
                }
                out.flush();
                if (corrupt != null) {
                    this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                    throw corrupt;
                }
            } else {
                try (CheckIndex checkIndex = new CheckIndex(this.store.directory());){
                    checkIndex.setInfoStream(out);
                    CheckIndex.Status status = checkIndex.checkIndex();
                    out.flush();
                    if (status.clean) break block27;
                    if (this.state == IndexShardState.CLOSED) {
                        return;
                    }
                    this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                    if ("fix".equalsIgnoreCase(this.checkIndexOnStartup)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("fixing index, writing new segments file ...", new Object[0]);
                        }
                        checkIndex.exorciseIndex(status);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("index fixed, wrote new segments file \"{}\"", status.segmentsFileName);
                        }
                        break block27;
                    }
                    throw new IllegalStateException("index check failure but can't fix it");
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("check index [success]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - timeNS)));
    }

    public Engine engine() {
        Engine engine = this.engineUnsafe();
        if (engine == null) {
            throw new EngineClosedException(this.shardId);
        }
        return engine;
    }

    protected Engine engineUnsafe() {
        return this.currentEngineReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewEngine(boolean skipTranslogRecovery, EngineConfig config) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new EngineClosedException(this.shardId);
            }
            assert (this.currentEngineReference.get() == null);
            this.currentEngineReference.set(this.newEngine(skipTranslogRecovery, config));
        }
        Engine engine = this.engineUnsafe();
        if (engine != null) {
            engine.onSettingsChanged();
        }
    }

    protected Engine newEngine(boolean skipTranslogRecovery, EngineConfig config) {
        return this.engineFactory.newReadWriteEngine(config, skipTranslogRecovery);
    }

    public boolean allowsPrimaryPromotion() {
        return true;
    }

    void persistMetadata(ShardRouting newRouting, ShardRouting currentRouting) {
        assert (newRouting != null) : "newRouting must not be null";
        if (newRouting.active()) {
            try {
                String writeReason;
                if (currentRouting == null) {
                    writeReason = "freshly started, version [" + newRouting.version() + "]";
                } else if (currentRouting.version() < newRouting.version()) {
                    writeReason = "version changed from [" + currentRouting.version() + "] to [" + newRouting.version() + "]";
                } else if (!currentRouting.equals(newRouting)) {
                    writeReason = "routing changed from " + currentRouting + " to " + newRouting;
                } else {
                    this.logger.trace("skip writing shard state, has been written before; previous version:  [" + currentRouting.version() + "] current version [" + newRouting.version() + "]", new Object[0]);
                    assert (currentRouting.version() <= newRouting.version()) : "version should not go backwards for shardID: " + this.shardId + " previous version:  [" + currentRouting.version() + "] current version [" + newRouting.version() + "]";
                    return;
                }
                ShardStateMetaData newShardStateMetadata = new ShardStateMetaData(newRouting.version(), newRouting.primary(), this.getIndexUUID());
                this.logger.trace("{} writing shard state, reason [{}]", this.shardId, writeReason);
                ShardStateMetaData.FORMAT.write(newShardStateMetadata, newShardStateMetadata.version, this.shardPath().getShardStatePath());
            }
            catch (IOException e) {
                this.logger.warn("failed to write shard state", e, new Object[0]);
            }
        }
    }

    private String getIndexUUID() {
        assert (this.indexSettings.get("index.uuid") != null || this.indexSettings.getAsVersion("index.version.created", Version.CURRENT).before(Version.V_0_90_6)) : "version: " + this.indexSettings.getAsVersion("index.version.created", null) + " uuid: " + this.indexSettings.get("index.uuid");
        return this.indexSettings.get("index.uuid", "_na_");
    }

    private DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(type);
    }

    private final EngineConfig newEngineConfig(TranslogConfig translogConfig, QueryCachingPolicy cachingPolicy) {
        TranslogRecoveryPerformer translogRecoveryPerformer = new TranslogRecoveryPerformer(this.shardId, this.mapperService, this.queryParserService, this.indexAliasesService, this.indexCache, this.logger){

            @Override
            protected void operationProcessed() {
                assert (IndexShard.this.recoveryState != null);
                IndexShard.this.recoveryState.getTranslog().incrementRecoveredOperations();
            }

            @Override
            public int recoveryFromSnapshot(Engine engine, Translog.Snapshot snapshot) throws IOException {
                assert (IndexShard.this.recoveryState != null);
                RecoveryState.Translog translogStats = IndexShard.this.recoveryState.getTranslog();
                translogStats.totalOperations(snapshot.estimatedTotalOperations());
                translogStats.totalOperationsOnStart(snapshot.estimatedTotalOperations());
                return super.recoveryFromSnapshot(engine, snapshot);
            }
        };
        return new EngineConfig(this.shardId, this.threadPool, this.indexingService, this.indexSettingsService.indexSettings(), this.warmer, this.store, this.deletionPolicy, this.mergePolicyConfig.getMergePolicy(), this.mergeSchedulerConfig, this.mapperService.indexAnalyzer(), this.similarityService.similarity(), this.codecService, this.failedEngineListener, translogRecoveryPerformer, this.indexCache.query(), cachingPolicy, this.wrappingService, translogConfig);
    }

    public void incrementOperationCounter() {
        this.indexShardOperationCounter.incRef();
    }

    public void decrementOperationCounter() {
        this.indexShardOperationCounter.decRef();
    }

    public int getOperationsCount() {
        return Math.max(0, this.indexShardOperationCounter.refCount() - 1);
    }

    public void sync(Translog.Location location) {
        try {
            Engine engine = this.engine();
            engine.getTranslog().ensureSynced(location);
        }
        catch (EngineClosedException engine) {
        }
        catch (IOException ex) {
            this.logger.debug("failed to sync translog", ex, new Object[0]);
            throw new ElasticsearchException("failed to sync translog", (Throwable)ex, new Object[0]);
        }
    }

    public Translog.Durabilty getTranslogDurability() {
        return this.translogConfig.getDurabilty();
    }

    private static Translog.Durabilty getFromSettings(ESLogger logger, Settings settings, Translog.Durabilty defaultValue) {
        String value = settings.get("index.translog.durability", defaultValue.name());
        try {
            return Translog.Durabilty.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Can't apply {} illegal value: {} using {} instead, use one of: {}", new Object[]{"index.translog.durability", value, defaultValue, Arrays.toString((Object[])Translog.Durabilty.values())});
            return defaultValue;
        }
    }

    private static class IndexShardOperationCounter
    extends AbstractRefCounted {
        private final ESLogger logger;
        private final ShardId shardId;

        public IndexShardOperationCounter(ESLogger logger, ShardId shardId) {
            super("index-shard-operations-counter");
            this.logger = logger;
            this.shardId = shardId;
        }

        @Override
        protected void closeInternal() {
            this.logger.debug("operations counter reached 0, will not accept any further writes", new Object[0]);
        }

        @Override
        protected void alreadyClosed() {
            throw new IndexShardClosedException(this.shardId, "could not increment operation counter. shard is closed.");
        }
    }

    class ShardEngineFailListener
    implements Engine.FailedEngineListener {
        private final CopyOnWriteArrayList<Engine.FailedEngineListener> delegates = new CopyOnWriteArrayList();

        ShardEngineFailListener() {
        }

        @Override
        public void onFailedEngine(ShardId shardId, String reason, @Nullable Throwable failure) {
            for (Engine.FailedEngineListener listener : this.delegates) {
                try {
                    listener.onFailedEngine(shardId, reason, failure);
                }
                catch (Exception e) {
                    IndexShard.this.logger.warn("exception while notifying engine failure", e, new Object[0]);
                }
            }
        }
    }

    class EngineRefresher
    implements Runnable {
        EngineRefresher() {
        }

        @Override
        public void run() {
            if (!IndexShard.this.engine().refreshNeeded()) {
                this.reschedule();
                return;
            }
            IndexShard.this.threadPool.executor("refresh").execute(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (IndexShard.this.engine().refreshNeeded()) {
                                IndexShard.this.refresh("schedule");
                            }
                        }
                        catch (EngineClosedException engineClosedException) {
                        }
                        catch (RefreshFailedEngineException e) {
                            if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || IndexShard.this.state == IndexShardState.CLOSED)) {
                                IndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (IndexShard.this.state == IndexShardState.CLOSED) break block6;
                            IndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    EngineRefresher.this.reschedule();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reschedule() {
            Object object = IndexShard.this.mutex;
            synchronized (object) {
                if (IndexShard.this.state != IndexShardState.CLOSED && IndexShard.this.refreshInterval.millis() > 0L) {
                    IndexShard.this.refreshScheduledFuture = IndexShard.this.threadPool.schedule(IndexShard.this.refreshInterval, "same", this);
                }
            }
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            boolean change = false;
            Object object = IndexShard.this.mutex;
            synchronized (object) {
                boolean autoThrottle;
                int maxMergeCount;
                int maxThreadCount;
                boolean compoundOnFlush;
                long gcDeletesInMillis;
                TimeValue refreshInterval;
                Translog.Durabilty durabilty;
                TranslogWriter.Type type;
                if (IndexShard.this.state() == IndexShardState.CLOSED) {
                    return;
                }
                EngineConfig config = IndexShard.this.engineConfig;
                boolean flushOnClose = settings.getAsBoolean(IndexShard.INDEX_FLUSH_ON_CLOSE, (Boolean)IndexShard.this.flushOnClose);
                if (flushOnClose != IndexShard.this.flushOnClose) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", IndexShard.INDEX_FLUSH_ON_CLOSE, IndexShard.this.flushOnClose, flushOnClose);
                    IndexShard.this.flushOnClose = flushOnClose;
                }
                if ((type = TranslogWriter.Type.fromString(settings.get("index.translog.fs.type", IndexShard.this.translogConfig.getType().name()))) != IndexShard.this.translogConfig.getType()) {
                    IndexShard.this.logger.info("updating type from [{}] to [{}]", new Object[]{IndexShard.this.translogConfig.getType(), type});
                    IndexShard.this.translogConfig.setType(type);
                }
                if ((durabilty = IndexShard.getFromSettings(IndexShard.this.logger, settings, IndexShard.this.translogConfig.getDurabilty())) != IndexShard.this.translogConfig.getDurabilty()) {
                    IndexShard.this.logger.info("updating durability from [{}] to [{}]", new Object[]{IndexShard.this.translogConfig.getDurabilty(), durabilty});
                    IndexShard.this.translogConfig.setDurabilty(durabilty);
                }
                if (!(refreshInterval = settings.getAsTime(IndexShard.INDEX_REFRESH_INTERVAL, IndexShard.this.refreshInterval)).equals(IndexShard.this.refreshInterval)) {
                    IndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", IndexShard.this.refreshInterval, refreshInterval);
                    if (IndexShard.this.refreshScheduledFuture != null) {
                        FutureUtils.cancel(IndexShard.this.refreshScheduledFuture);
                        IndexShard.this.refreshScheduledFuture = null;
                    }
                    IndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        IndexShard.this.refreshScheduledFuture = IndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
                if ((gcDeletesInMillis = settings.getAsTime("index.gc_deletes", TimeValue.timeValueMillis(config.getGcDeletesInMillis())).millis()) != config.getGcDeletesInMillis()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.gc_deletes", TimeValue.timeValueMillis(config.getGcDeletesInMillis()), TimeValue.timeValueMillis(gcDeletesInMillis));
                    config.setGcDeletesInMillis(gcDeletesInMillis);
                    change = true;
                }
                if ((compoundOnFlush = settings.getAsBoolean("index.compound_on_flush", (Boolean)config.isCompoundOnFlush()).booleanValue()) != config.isCompoundOnFlush()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.compound_on_flush", config.isCompoundOnFlush(), compoundOnFlush);
                    config.setCompoundOnFlush(compoundOnFlush);
                    change = true;
                }
                String versionMapSize = settings.get("index.version_map_size", config.getVersionMapSizeSetting());
                if (!config.getVersionMapSizeSetting().equals(versionMapSize)) {
                    config.setVersionMapSizeSetting(versionMapSize);
                }
                if ((maxThreadCount = settings.getAsInt("index.merge.scheduler.max_thread_count", (Integer)IndexShard.this.mergeSchedulerConfig.getMaxThreadCount()).intValue()) != IndexShard.this.mergeSchedulerConfig.getMaxThreadCount()) {
                    IndexShard.this.logger.info("updating [{}] from [{}] to [{}]", "index.merge.scheduler.max_thread_count", IndexShard.this.mergeSchedulerConfig.getMaxThreadCount(), maxThreadCount);
                    IndexShard.this.mergeSchedulerConfig.setMaxThreadCount(maxThreadCount);
                    change = true;
                }
                if ((maxMergeCount = settings.getAsInt("index.merge.scheduler.max_merge_count", (Integer)IndexShard.this.mergeSchedulerConfig.getMaxMergeCount()).intValue()) != IndexShard.this.mergeSchedulerConfig.getMaxMergeCount()) {
                    IndexShard.this.logger.info("updating [{}] from [{}] to [{}]", "index.merge.scheduler.max_merge_count", IndexShard.this.mergeSchedulerConfig.getMaxMergeCount(), maxMergeCount);
                    IndexShard.this.mergeSchedulerConfig.setMaxMergeCount(maxMergeCount);
                    change = true;
                }
                if ((autoThrottle = settings.getAsBoolean("index.merge.scheduler.auto_throttle", (Boolean)IndexShard.this.mergeSchedulerConfig.isAutoThrottle()).booleanValue()) != IndexShard.this.mergeSchedulerConfig.isAutoThrottle()) {
                    IndexShard.this.logger.info("updating [{}] from [{}] to [{}]", "index.merge.scheduler.auto_throttle", IndexShard.this.mergeSchedulerConfig.isAutoThrottle(), autoThrottle);
                    IndexShard.this.mergeSchedulerConfig.setAutoThrottle(autoThrottle);
                    change = true;
                }
            }
            IndexShard.this.mergePolicyConfig.onRefreshSettings(settings);
            IndexShard.this.searchService.onRefreshSettings(settings);
            IndexShard.this.indexingService.onRefreshSettings(settings);
            if (change) {
                IndexShard.this.engine().onSettingsChanged();
            }
        }
    }
}

