/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxMoveResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;

public class DropboxMoveProducer
extends DropboxProducer {
    public DropboxMoveProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        DropboxMoveResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).move(this.configuration.getRemotePath(), this.configuration.getNewRemotePath());
        exchange.getIn().setHeader(DropboxResultHeader.MOVED_PATH.name(), (Object)result.getOldPath());
        exchange.getIn().setBody((Object)result.getNewPath());
        this.log.debug("Moved from {} to {}", (Object)this.configuration.getRemotePath(), (Object)this.configuration.getNewRemotePath());
    }
}

