/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.converter;

import org.apache.camel.Converter;
import org.apache.hadoop.hbase.util.Bytes;

@Converter
public final class HBaseModelConverter {
    private HBaseModelConverter() {
    }

    @Converter
    public static byte[] booleanToBytes(Boolean bool) {
        return Bytes.toBytes((boolean)bool);
    }

    @Converter
    public static Boolean bytesToBoolean(byte[] bytes) {
        return Bytes.toBoolean((byte[])bytes);
    }

    @Converter
    public static byte[] shortToBytes(Short num) {
        return Bytes.toBytes((short)num);
    }

    @Converter
    public static Short bytesToShort(byte[] bytes) {
        return Bytes.toShort((byte[])bytes);
    }

    @Converter
    public static byte[] integerToBytes(Integer num) {
        return Bytes.toBytes((int)num);
    }

    @Converter
    public static Integer bytesToInteger(byte[] bytes) {
        return Bytes.toInt((byte[])bytes);
    }

    @Converter
    public static byte[] longToBytes(Long num) {
        return Bytes.toBytes((long)num);
    }

    @Converter
    public static Long bytesToLong(byte[] bytes) {
        return Bytes.toLong((byte[])bytes);
    }

    @Converter
    public static byte[] doubleToBytes(Double num) {
        return Bytes.toBytes((double)num);
    }

    @Converter
    public static Double bytesToDouble(byte[] bytes) {
        return Bytes.toDouble((byte[])bytes);
    }

    @Converter
    public static byte[] floatToBytes(Float num) {
        return Bytes.toBytes((float)num.floatValue());
    }

    @Converter
    public static Float bytesToFloat(byte[] bytes) {
        return Float.valueOf(Bytes.toFloat((byte[])bytes));
    }
}

