/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.stored.template.ast.InputParameter;
import org.apache.camel.component.sql.stored.template.ast.OutParameter;
import org.apache.camel.component.sql.stored.template.ast.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.StoredProcedure;

public class TemplateStoredProcedure
extends StoredProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateStoredProcedure.class);
    private final Template template;
    private List<InputParameter> inputParameterList = new ArrayList<InputParameter>();

    public TemplateStoredProcedure(JdbcTemplate jdbcTemplate, Template template, boolean function) {
        this.template = template;
        this.setFunction(function);
        this.setDataSource(jdbcTemplate.getDataSource());
        this.setSql(template.getProcedureName());
        for (Object parameter : template.getParameterList()) {
            if (parameter instanceof InputParameter) {
                InputParameter inputParameter = (InputParameter)parameter;
                this.declareParameter(new SqlParameter(inputParameter.getName(), inputParameter.getSqlType()));
                this.inputParameterList.add(inputParameter);
                continue;
            }
            if (!(parameter instanceof OutParameter)) continue;
            OutParameter outParameter = (OutParameter)parameter;
            this.declareParameter((SqlParameter)new SqlOutParameter(outParameter.getOutValueMapKey(), outParameter.getSqlType()));
        }
        LOG.debug("Compiling stored procedure: {}", (Object)template.getProcedureName());
        this.compile();
    }

    public Map execute(Exchange exchange, Object rowData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (InputParameter inputParameter : this.inputParameterList) {
            params.put(inputParameter.getName(), inputParameter.getValueExtractor().eval(exchange, rowData));
        }
        LOG.debug("Invoking stored procedure: {}", (Object)this.template.getProcedureName());
        return super.execute(params);
    }

    public Template getTemplate() {
        return this.template;
    }
}

