/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import twitter4j.ExtendedMediaEntity;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.MediaEntityJSONImpl;
import twitter4j.TwitterException;

public class ExtendedMediaEntityJSONImpl
extends MediaEntityJSONImpl
implements ExtendedMediaEntity {
    private static final long serialVersionUID = -3889082303259253211L;
    private int videoAspectRatioWidth;
    private int videoAspectRatioHeight;
    private long videoDurationMillis;
    private Variant[] videoVariants;
    private String extAltText;

    ExtendedMediaEntityJSONImpl(JSONObject json) throws TwitterException {
        super(json);
        try {
            if (json.has("video_info")) {
                JSONObject videoInfo = json.getJSONObject("video_info");
                JSONArray aspectRatio = videoInfo.getJSONArray("aspect_ratio");
                this.videoAspectRatioWidth = aspectRatio.getInt(0);
                this.videoAspectRatioHeight = aspectRatio.getInt(1);
                if (!videoInfo.isNull("duration_millis")) {
                    this.videoDurationMillis = videoInfo.getLong("duration_millis");
                }
                JSONArray variants = videoInfo.getJSONArray("variants");
                this.videoVariants = new Variant[variants.length()];
                for (int i = 0; i < variants.length(); ++i) {
                    this.videoVariants[i] = new Variant(variants.getJSONObject(i));
                }
            } else {
                this.videoVariants = new Variant[0];
            }
            if (json.has("ext_alt_text")) {
                this.extAltText = json.getString("ext_alt_text");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    ExtendedMediaEntityJSONImpl() {
    }

    @Override
    public int getVideoAspectRatioWidth() {
        return this.videoAspectRatioWidth;
    }

    @Override
    public int getVideoAspectRatioHeight() {
        return this.videoAspectRatioHeight;
    }

    @Override
    public long getVideoDurationMillis() {
        return this.videoDurationMillis;
    }

    @Override
    public String getExtAltText() {
        return this.extAltText;
    }

    @Override
    public ExtendedMediaEntity.Variant[] getVideoVariants() {
        return this.videoVariants;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendedMediaEntityJSONImpl)) {
            return false;
        }
        ExtendedMediaEntityJSONImpl that = (ExtendedMediaEntityJSONImpl)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    @Override
    public String toString() {
        return "ExtendedMediaEntityJSONImpl{id=" + this.id + ", url=" + this.url + ", mediaURL=" + this.mediaURL + ", mediaURLHttps=" + this.mediaURLHttps + ", expandedURL=" + this.expandedURL + ", displayURL='" + this.displayURL + '\'' + ", sizes=" + this.sizes + ", type=" + this.type + ", videoAspectRatioWidth=" + this.videoAspectRatioWidth + ", videoAspectRatioHeight=" + this.videoAspectRatioHeight + ", videoDurationMillis=" + this.videoDurationMillis + ", extAltText=" + this.extAltText + ", videoVariants=" + Arrays.toString(this.videoVariants) + '}';
    }

    static class Variant
    implements ExtendedMediaEntity.Variant {
        private static final long serialVersionUID = 1027236588556797980L;
        int bitrate;
        String contentType;
        String url;

        Variant(JSONObject json) throws JSONException {
            this.bitrate = json.has("bitrate") ? json.getInt("bitrate") : 0;
            this.contentType = json.getString("content_type");
            this.url = json.getString("url");
        }

        Variant() {
        }

        @Override
        public int getBitrate() {
            return this.bitrate;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant variant = (Variant)o;
            if (this.bitrate != variant.bitrate) {
                return false;
            }
            if (!this.contentType.equals(variant.contentType)) {
                return false;
            }
            return this.url.equals(variant.url);
        }

        public int hashCode() {
            int result = this.bitrate;
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Variant{bitrate=" + this.bitrate + ", contentType=" + this.contentType + ", url=" + this.url + '}';
        }
    }
}

