/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSdkVersion;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;

public class DbxRequestUtil {
    public static String encodeUrlParam(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw LangUtil.mkAssert("UTF-8 should always be supported", ex);
        }
    }

    public static String buildUrlWithParams(String userLocale, String host, String path, String[] params) {
        return DbxRequestUtil.buildUri(host, path) + "?" + DbxRequestUtil.encodeUrlParams(userLocale, params);
    }

    public static String buildUri(String host, String path) {
        try {
            return new URI("https", host, "/" + path, null).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw LangUtil.mkAssert("URI creation failed, host=" + StringUtil.jq(host) + ", path=" + StringUtil.jq(path), ex);
        }
    }

    private static String encodeUrlParams(String userLocale, String[] params) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (userLocale != null) {
            buf.append("locale=").append(userLocale);
            sep = "&";
        }
        if (params != null) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("'params.length' is " + params.length + "; expecting a multiple of two");
            }
            for (int i = 0; i < params.length; i += 2) {
                String key = params[i];
                String value = params[i + 1];
                if (key == null) {
                    throw new IllegalArgumentException("params[" + i + "] is null");
                }
                if (value == null) continue;
                buf.append(sep);
                sep = "&";
                buf.append(DbxRequestUtil.encodeUrlParam(key));
                buf.append("=");
                buf.append(DbxRequestUtil.encodeUrlParam(value));
            }
        }
        return buf.toString();
    }

    private static ArrayList<HttpRequestor.Header> addAuthHeader(ArrayList<HttpRequestor.Header> headers, String accessToken) {
        if (headers == null) {
            headers = new ArrayList();
        }
        headers.add(new HttpRequestor.Header("Authorization", "Bearer " + accessToken));
        return headers;
    }

    public static ArrayList<HttpRequestor.Header> addUserAgentHeader(ArrayList<HttpRequestor.Header> headers, DbxRequestConfig requestConfig) {
        if (headers == null) {
            headers = new ArrayList();
        }
        headers.add(DbxRequestUtil.buildUserAgentHeader(requestConfig));
        return headers;
    }

    public static HttpRequestor.Header buildUserAgentHeader(DbxRequestConfig requestConfig) {
        return new HttpRequestor.Header("User-Agent", requestConfig.clientIdentifier + " Dropbox-Java-SDK/" + DbxSdkVersion.Version);
    }

    public static HttpRequestor.Response startGet(DbxRequestConfig requestConfig, String accessToken, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers) throws DbxException.NetworkIO {
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig);
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        String url = DbxRequestUtil.buildUrlWithParams(requestConfig.userLocale, host, path, params);
        try {
            return requestConfig.httpRequestor.doGet(url, headers);
        }
        catch (IOException ex) {
            throw new DbxException.NetworkIO(ex);
        }
    }

    public static HttpRequestor.Uploader startPut(DbxRequestConfig requestConfig, String accessToken, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers) throws DbxException.NetworkIO {
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig);
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        String url = DbxRequestUtil.buildUrlWithParams(requestConfig.userLocale, host, path, params);
        try {
            return requestConfig.httpRequestor.startPut(url, headers);
        }
        catch (IOException ex) {
            throw new DbxException.NetworkIO(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequestor.Response startPostNoAuth(DbxRequestConfig requestConfig, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers) throws DbxException.NetworkIO {
        String uri = DbxRequestUtil.buildUri(host, path);
        byte[] encodedParams = StringUtil.stringToUtf8(DbxRequestUtil.encodeUrlParams(requestConfig.userLocale, params));
        headers = DbxRequestUtil.addUserAgentHeader(headers, requestConfig);
        headers.add(new HttpRequestor.Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        headers.add(new HttpRequestor.Header("Content-Length", Integer.toString(encodedParams.length)));
        HttpRequestor.Uploader uploader = requestConfig.httpRequestor.startPost(uri, headers);
        try {
            uploader.body.write(encodedParams);
            HttpRequestor.Response response = uploader.finish();
            uploader.close();
            return response;
        }
        catch (Throwable throwable) {
            try {
                uploader.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new DbxException.NetworkIO(ex);
            }
        }
    }

    public static byte[] loadErrorBody(HttpRequestor.Response response) throws DbxException.NetworkIO {
        try {
            return IOUtil.slurp(response.body, 4096);
        }
        catch (IOException ex) {
            throw new DbxException.NetworkIO(ex);
        }
    }

    public static String parseErrorBody(int statusCode, byte[] body) throws DbxException.BadResponse {
        try {
            return StringUtil.utf8ToString(body);
        }
        catch (CharacterCodingException e) {
            throw new DbxException.BadResponse("Got non-UTF8 response body: " + statusCode + ": " + e.getMessage());
        }
    }

    public static DbxException unexpectedStatus(HttpRequestor.Response response) throws DbxException.NetworkIO, DbxException.BadResponse {
        byte[] body = DbxRequestUtil.loadErrorBody(response);
        String message = DbxRequestUtil.parseErrorBody(response.statusCode, body);
        if (response.statusCode == 400) {
            return new DbxException.BadRequest(message);
        }
        if (response.statusCode == 401) {
            return new DbxException.InvalidAccessToken(message);
        }
        if (response.statusCode == 500) {
            return new DbxException.ServerError(message);
        }
        if (response.statusCode == 503) {
            return new DbxException.RetryLater(message);
        }
        return new DbxException.BadResponseCode("unexpected HTTP status code: " + response.statusCode + ": " + message, response.statusCode);
    }

    public static <T> T readJsonFromResponse(JsonReader<T> reader, InputStream body) throws DbxException.BadResponse, DbxException.NetworkIO {
        try {
            return reader.readFully(body);
        }
        catch (JsonReadException ex) {
            throw new DbxException.BadResponse("error in response JSON: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DbxException.NetworkIO(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doGet(DbxRequestConfig requestConfig, String accessToken, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, ResponseHandler<T> handler) throws DbxException {
        HttpRequestor.Response response = DbxRequestUtil.startGet(requestConfig, accessToken, host, path, params, headers);
        try {
            T t = handler.handle(response);
            return t;
        }
        finally {
            try {
                response.body.close();
            }
            catch (IOException ex) {
                throw new DbxException.NetworkIO(ex);
            }
        }
    }

    public static <T> T doPost(DbxRequestConfig requestConfig, String accessToken, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, ResponseHandler<T> handler) throws DbxException {
        headers = DbxRequestUtil.addAuthHeader(headers, accessToken);
        return DbxRequestUtil.doPostNoAuth(requestConfig, host, path, params, headers, handler);
    }

    public static <T> T doPostNoAuth(DbxRequestConfig requestConfig, String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, ResponseHandler<T> handler) throws DbxException {
        HttpRequestor.Response response = DbxRequestUtil.startPostNoAuth(requestConfig, host, path, params, headers);
        return DbxRequestUtil.finishResponse(response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T finishResponse(HttpRequestor.Response response, ResponseHandler<T> handler) throws DbxException {
        try {
            T t = handler.handle(response);
            return t;
        }
        finally {
            IOUtil.closeInput(response.body);
        }
    }

    public static String getFirstHeader(HttpRequestor.Response response, String name) throws DbxException {
        List<String> values = response.headers.get(name);
        if (values == null) {
            throw new DbxException.BadResponse("missing HTTP header \"" + name + "\"");
        }
        assert (!values.isEmpty());
        return values.get(0);
    }

    public static String getFirstHeaderMaybe(HttpRequestor.Response response, String name) throws DbxException {
        List<String> values = response.headers.get(name);
        if (values == null) {
            return null;
        }
        assert (!values.isEmpty());
        return values.get(0);
    }

    public static <T, E extends Throwable> T runAndRetry(int maxTries, RequestMaker<T, E> requestMaker) throws DbxException, E {
        int numTries = 0;
        while (true) {
            try {
                ++numTries;
                return requestMaker.run();
            }
            catch (DbxException ex) {
                if (DbxRequestUtil.isRetriableException(ex) && numTries < maxTries) continue;
                throw ex;
            }
            break;
        }
    }

    private static boolean isRetriableException(DbxException ex) {
        return ex instanceof DbxException.RetryLater || ex instanceof DbxException.ServerError;
    }

    public static abstract class RequestMaker<T, E extends Throwable> {
        public abstract T run() throws DbxException, E;
    }

    public static abstract class ResponseHandler<T> {
        public abstract T handle(HttpRequestor.Response var1) throws DbxException;
    }
}

