/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.dozer.DozerComponent;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerTypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.dozer.DozerBeanMapper;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.MappingFileData;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.DozerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerTypeConverterLoader
extends ServiceSupport
implements CamelContextAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CamelContext camelContext;
    private transient DozerBeanMapperConfiguration configuration;
    private transient DozerBeanMapper mapper;

    public DozerTypeConverterLoader() {
    }

    public DozerTypeConverterLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        try {
            camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public DozerTypeConverterLoader(CamelContext camelContext, DozerBeanMapperConfiguration configuration) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader appcl = camelContext.getApplicationContextClassLoader();
            if (appcl != null) {
                Thread.currentThread().setContextClassLoader(appcl);
            }
            this.log.info("Using DozerBeanMapperConfiguration: {}", (Object)configuration);
            DozerBeanMapper mapper = DozerTypeConverterLoader.createDozerBeanMapper(configuration);
            this.camelContext = camelContext;
            this.mapper = mapper;
            this.configuration = configuration;
            camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Deprecated
    public DozerTypeConverterLoader(CamelContext camelContext, DozerBeanMapper mapper) {
        this.camelContext = camelContext;
        this.mapper = mapper;
        try {
            camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CamelContext camelContext, DozerBeanMapper mapper) {
        this.camelContext = camelContext;
        if (mapper != null) {
            this.mapper = mapper;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Map<String, DozerBeanMapperConfiguration> configurations;
            ClassLoader appcl = camelContext.getApplicationContextClassLoader();
            if (appcl != null) {
                Thread.currentThread().setContextClassLoader(appcl);
            }
            Map<String, DozerBeanMapper> mappers = this.lookupDozerBeanMappers();
            if (mapper != null && !mappers.containsValue(mapper)) {
                mappers.put("parameter", mapper);
            }
            if ((configurations = this.lookupDozerBeanMapperConfigurations()) != null && this.configuration != null) {
                Object key = null;
                for (Map.Entry<String, DozerBeanMapperConfiguration> entry : configurations.entrySet()) {
                    if (entry.getValue() != this.configuration) continue;
                    key = entry.getKey();
                    break;
                }
                if (key != null) {
                    configurations.remove(key);
                }
            }
            if (configurations != null) {
                if (configurations.size() > 1) {
                    this.log.warn("Loaded " + configurations.size() + " Dozer configurations from Camel registry. Dozer is most efficient when there is a single mapper instance. Consider amalgamating instances.");
                }
                for (Map.Entry<String, DozerBeanMapperConfiguration> entry : configurations.entrySet()) {
                    String string = entry.getKey();
                    DozerBeanMapper beanMapper = DozerTypeConverterLoader.createDozerBeanMapper(entry.getValue());
                    if (mappers.containsValue(beanMapper)) continue;
                    mappers.put(string, beanMapper);
                }
            }
            if (mappers.size() > 1) {
                this.log.warn("Loaded " + mappers.size() + " Dozer mappers from Camel registry. Dozer is most efficient when there is a single mapper instance. Consider amalgamating instances.");
            } else if (mappers.size() == 0) {
                this.log.warn("No Dozer mappers found in Camel registry. You should add Dozer mappers as beans to the registry of the type: " + DozerBeanMapper.class.getName());
            }
            TypeConverterRegistry registry = camelContext.getTypeConverterRegistry();
            for (Map.Entry<String, DozerBeanMapperConfiguration> entry : mappers.entrySet()) {
                String mapperId = entry.getKey();
                DozerBeanMapper dozer = (DozerBeanMapper)entry.getValue();
                List<ClassMap> all = this.loadMappings(camelContext, mapperId, dozer);
                this.registerClassMaps(registry, mapperId, dozer, all);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public static DozerBeanMapper createDozerBeanMapper(DozerBeanMapperConfiguration configuration) {
        DozerBeanMapper mapper = configuration.getMappingFiles() != null ? DozerComponent.createDozerBeanMapper(configuration.getMappingFiles()) : DozerComponent.createDozerBeanMapper(Collections.emptyList());
        if (configuration.getCustomConverters() != null) {
            mapper.setCustomConverters(configuration.getCustomConverters());
        }
        if (configuration.getEventListeners() != null) {
            mapper.setEventListeners(configuration.getEventListeners());
        }
        if (configuration.getCustomConvertersWithId() != null) {
            mapper.setCustomConvertersWithId(configuration.getCustomConvertersWithId());
        }
        if (configuration.getCustomFieldMapper() != null) {
            mapper.setCustomFieldMapper(configuration.getCustomFieldMapper());
        }
        return mapper;
    }

    protected Map<String, DozerBeanMapper> lookupDozerBeanMappers() {
        return new HashMap<String, DozerBeanMapper>(this.camelContext.getRegistry().findByTypeWithName(DozerBeanMapper.class));
    }

    protected Map<String, DozerBeanMapperConfiguration> lookupDozerBeanMapperConfigurations() {
        return new HashMap<String, DozerBeanMapperConfiguration>(this.camelContext.getRegistry().findByTypeWithName(DozerBeanMapperConfiguration.class));
    }

    protected void registerClassMaps(TypeConverterRegistry registry, String dozerId, DozerBeanMapper dozer, List<ClassMap> all) {
        DozerTypeConverter converter = new DozerTypeConverter(dozer);
        for (ClassMap map : all) {
            this.addDozerTypeConverter(registry, converter, dozerId, map.getSrcClassToMap(), map.getDestClassToMap());
            if (map.getType() == MappingDirection.ONE_WAY) continue;
            this.addDozerTypeConverter(registry, converter, dozerId, map.getDestClassToMap(), map.getSrcClassToMap());
        }
    }

    protected void addDozerTypeConverter(TypeConverterRegistry registry, DozerTypeConverter converter, String dozerId, Class<?> to, Class<?> from) {
        if (this.log.isInfoEnabled()) {
            if (dozerId != null) {
                this.log.info("Added Dozer: {} as Camel type converter: {} -> {}", new Object[]{dozerId, from, to});
            } else {
                this.log.info("Added Dozer as Camel type converter: {} -> {}", new Object[]{from, to});
            }
        }
        registry.addTypeConverter(from, to, (TypeConverter)converter);
    }

    private List<ClassMap> loadMappings(CamelContext camelContext, String mapperId, DozerBeanMapper mapper) {
        ArrayList<ClassMap> answer = new ArrayList<ClassMap>();
        MappingFileReader reader = new MappingFileReader(XMLParserFactory.getInstance());
        List mappingFiles = mapper.getMappingFiles();
        if (mappingFiles == null) {
            return Collections.emptyList();
        }
        for (String name : mappingFiles) {
            URL url = DozerTypeConverterLoader.loadMappingFile(camelContext.getClassResolver(), name);
            if (url == null) continue;
            MappingFileData data = reader.read(url);
            answer.addAll(data.getClassMaps());
        }
        return answer;
    }

    public void addMapping(BeanMappingBuilder beanMappingBuilder) {
        if (this.mapper == null) {
            this.log.warn("No mapper instance provided to " + ((Object)((Object)this)).getClass().getSimpleName() + ". Mapping has not been registered!");
            return;
        }
        this.mapper.addMapping(beanMappingBuilder);
        MappingFileData mappingFileData = beanMappingBuilder.build();
        TypeConverterRegistry registry = this.camelContext.getTypeConverterRegistry();
        ArrayList<ClassMap> classMaps = new ArrayList<ClassMap>();
        classMaps.addAll(mappingFileData.getClassMaps());
        this.registerClassMaps(registry, null, this.mapper, classMaps);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        if (this.camelContext == null) {
            this.camelContext = camelContext;
            try {
                camelContext.addService((Object)this);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public DozerBeanMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(DozerBeanMapper mapper) {
        this.mapper = mapper;
    }

    protected static URL loadMappingFile(ClassResolver classResolver, String mappingFile) {
        URL url = null;
        try {
            url = ResourceHelper.resolveResourceAsUrl((ClassResolver)classResolver, (String)mappingFile);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            url = DozerClassLoader.class.getClassLoader().getResource(mappingFile);
        }
        return url;
    }

    protected void doStart() throws Exception {
        this.init(this.camelContext, this.mapper);
    }

    protected void doStop() throws Exception {
    }
}

