/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.BatchAttachment;
import facebook4j.internal.http.RequestMethod;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRequest
implements Serializable {
    private static final long serialVersionUID = -7720882981733337599L;
    private final RequestMethod method;
    private final String relativeUrl;
    private String name;
    private String body;
    private Boolean omitResponseOnSuccess;
    private String dependsOn;
    private String accessToken;
    private List<BatchAttachment> attachedFiles;
    private JSONObject json = null;

    public BatchRequest(RequestMethod method, String relativeUrl) {
        this.method = method;
        this.relativeUrl = relativeUrl;
    }

    public String getMethod() {
        return this.method.name();
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BatchRequest name(String name) {
        this.setName(name);
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public BatchRequest body(String body) {
        this.setBody(body);
        return this;
    }

    public Boolean isOmitResponseOnSuccess() {
        return this.omitResponseOnSuccess;
    }

    public void setOmitResponseOnSuccess(Boolean omitResponseOnSuccess) {
        this.omitResponseOnSuccess = omitResponseOnSuccess;
    }

    public BatchRequest omitResponseOnSuccess(Boolean omitResponseOnSuccess) {
        this.setOmitResponseOnSuccess(omitResponseOnSuccess);
        return this;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public BatchRequest dependsOn(String dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public BatchRequest accessToken(String accessToken) {
        this.setAccessToken(accessToken);
        return this;
    }

    public List<BatchAttachment> getAttachedFiles() {
        return this.attachedFiles;
    }

    public void setAttachedFiles(List<BatchAttachment> attachedFiles) {
        this.attachedFiles = attachedFiles;
    }

    public BatchRequest attachedFiles(List<BatchAttachment> attachedFiles) {
        this.setAttachedFiles(attachedFiles);
        return this;
    }

    public void addAttachedFile(BatchAttachment attachedFile) {
        if (this.attachedFiles == null) {
            this.attachedFiles = new ArrayList<BatchAttachment>();
        }
        this.attachedFiles.add(attachedFile);
    }

    public BatchRequest attachedFile(BatchAttachment attachedFile) {
        this.addAttachedFile(attachedFile);
        return this;
    }

    public JSONObject asJSONObject() {
        if (this.json == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("method", this.getMethod());
            map.put("relative_url", this.getRelativeUrl());
            map.put("name", this.getName());
            map.put("body", this.getBody());
            map.put("omit_response_on_success", this.isOmitResponseOnSuccess());
            map.put("depends_on", this.getDependsOn());
            map.put("access_token", this.getAccessToken());
            if (this.attachedFiles != null && !this.attachedFiles.isEmpty()) {
                ArrayList<String> filenames = new ArrayList<String>(this.attachedFiles.size());
                for (BatchAttachment attachedFile : this.attachedFiles) {
                    filenames.add(attachedFile.getName());
                }
                map.put("attached_files", z_F4JInternalStringUtil.join(filenames.toArray(new String[filenames.size()]), ","));
            }
            this.json = new JSONObject(map);
        }
        return this.json;
    }

    public String asJSONString() {
        return this.asJSONObject().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchRequest)) {
            return false;
        }
        BatchRequest that = (BatchRequest)o;
        if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) {
            return false;
        }
        if (this.attachedFiles != null ? !((Object)this.attachedFiles).equals(that.attachedFiles) : that.attachedFiles != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.omitResponseOnSuccess != null ? !this.omitResponseOnSuccess.equals(that.omitResponseOnSuccess) : that.omitResponseOnSuccess != null) {
            return false;
        }
        return !(this.relativeUrl != null ? !this.relativeUrl.equals(that.relativeUrl) : that.relativeUrl != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.relativeUrl != null ? this.relativeUrl.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.omitResponseOnSuccess != null ? this.omitResponseOnSuccess.hashCode() : 0);
        result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        result = 31 * result + (this.attachedFiles != null ? ((Object)this.attachedFiles).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BatchRequest{method=" + this.method.name() + ", relativeUrl='" + this.relativeUrl + '\'' + ", name='" + this.name + '\'' + ", body=" + this.body + ", omitResponseOnSuccess=" + this.omitResponseOnSuccess + ", dependsOn='" + this.dependsOn + '\'' + ", accessToken='" + this.accessToken + '\'' + ", attachedFiles='" + this.attachedFiles + '\'' + '}';
    }
}

