/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.BatchAttachment;
import facebook4j.BatchRequest;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRequests<T extends BatchRequest>
extends ArrayList<T> {
    private static final long serialVersionUID = -9123525320485721265L;
    private Boolean includeHeaders;

    public Boolean getIncludeHeaders() {
        return this.includeHeaders;
    }

    public void setIncludeHeaders(Boolean includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (this.includeHeaders != null) {
            params.add(new HttpParameter("include_headers", this.includeHeaders));
        }
        ArrayList<String> jsons = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            BatchRequest batch = (BatchRequest)this.get(i);
            jsons.add(batch.asJSONString());
            if (batch.getAttachedFiles() == null) continue;
            for (BatchAttachment attachedFile : batch.getAttachedFiles()) {
                params.add(attachedFile.asHttpParameter());
            }
        }
        String batchJSONString = "[" + z_F4JInternalStringUtil.join(jsons.toArray(new String[jsons.size()])) + "]";
        params.add(new HttpParameter("batch", batchJSONString));
        return params.toArray(new HttpParameter[params.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchRequests)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BatchRequests that = (BatchRequests)o;
        return !(this.includeHeaders != null ? !this.includeHeaders.equals(that.includeHeaders) : that.includeHeaders != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.includeHeaders != null ? this.includeHeaders.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "BatchRequests{includeHeaders=" + this.includeHeaders + "} " + super.toString();
    }
}

