/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.http;

import facebook4j.FacebookException;
import facebook4j.auth.Authorization;
import facebook4j.conf.ConfigurationContext;
import facebook4j.internal.http.HttpClient;
import facebook4j.internal.http.HttpClientFactory;
import facebook4j.internal.http.HttpClientWrapperConfiguration;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.http.HttpRequest;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.http.HttpResponseEvent;
import facebook4j.internal.http.HttpResponseListener;
import facebook4j.internal.http.RequestMethod;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientWrapper
implements Serializable {
    private final HttpClientWrapperConfiguration wrapperConf;
    private HttpClient http;
    private final Map<String, String> requestHeaders;
    private static final long serialVersionUID = -6511977105603119379L;
    private HttpResponseListener httpResponseListener;

    public HttpClientWrapper(HttpClientWrapperConfiguration wrapperConf) {
        this.wrapperConf = wrapperConf;
        this.requestHeaders = wrapperConf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(wrapperConf);
    }

    public HttpClientWrapper() {
        this.wrapperConf = ConfigurationContext.getInstance();
        this.requestHeaders = this.wrapperConf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(this.wrapperConf);
    }

    public void shutdown() {
        this.http.shutdown();
    }

    protected HttpResponse request(HttpRequest req) throws FacebookException {
        HttpResponse res;
        try {
            res = this.http.request(req);
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, res, null));
            }
        }
        catch (FacebookException fe) {
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, null, fe));
            }
            throw fe;
        }
        return res;
    }

    public void setHttpResponseListener(HttpResponseListener listener) {
        this.httpResponseListener = listener;
    }

    public HttpResponse get(String url, HttpParameter[] parameters, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse get(String url, HttpParameter[] parameters) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse get(String url, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse get(String url) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Map<String, String> requestHeaders) throws FacebookException {
        HashMap<String, String> headers = new HashMap<String, String>(this.requestHeaders);
        if (requestHeaders != null) {
            headers.putAll(requestHeaders);
        }
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, headers));
    }

    public HttpResponse post(String url, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse head(String url, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse put(String url, Authorization authorization) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url) throws FacebookException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, this.requestHeaders));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientWrapper that = (HttpClientWrapper)o;
        if (!this.http.equals(that.http)) {
            return false;
        }
        if (!((Object)this.requestHeaders).equals(that.requestHeaders)) {
            return false;
        }
        return this.wrapperConf.equals(that.wrapperConf);
    }

    public int hashCode() {
        int result = this.wrapperConf.hashCode();
        result = 31 * result + this.http.hashCode();
        result = 31 * result + ((Object)this.requestHeaders).hashCode();
        return result;
    }

    public String toString() {
        return "HttpClientWrapper{wrapperConf=" + this.wrapperConf + ", http=" + this.http + ", requestHeaders=" + this.requestHeaders + ", httpResponseListener=" + this.httpResponseListener + '}';
    }
}

