/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe.kdf;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.UncheckedJoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatKeyDerivationFunction {
    private static final Logger log = LoggerFactory.getLogger(ConcatKeyDerivationFunction.class);
    private int digestLength;
    private MessageDigest messageDigest;

    public ConcatKeyDerivationFunction(String hashAlgoritm) {
        this.messageDigest = this.getMessageDigest(hashAlgoritm);
        this.digestLength = ByteUtil.bitLength(this.messageDigest.getDigestLength());
        log.debug("Hash Algorithm: {} with hashlen: {} bits", (Object)hashAlgoritm, (Object)this.digestLength);
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] algorithmId, byte[] partyUInfo, byte[] partyVInfo, byte[] suppPubInfo, byte[] suppPrivInfo) {
        log.debug("KDF:");
        log.debug("  z: {}", (Object)ByteUtil.toDebugString(sharedSecret));
        log.debug("  keydatalen: {}", (Object)keydatalen);
        log.debug("  algorithmId: {}", (Object)ByteUtil.toDebugString(algorithmId));
        log.debug("  partyUInfo: {}", (Object)ByteUtil.toDebugString(partyUInfo));
        log.debug("  partyVInfo: {}", (Object)ByteUtil.toDebugString(partyVInfo));
        log.debug("  suppPubInfo: {}", (Object)ByteUtil.toDebugString(suppPubInfo));
        log.debug("  suppPrivInfo: {}", (Object)ByteUtil.toDebugString(suppPrivInfo));
        byte[] otherInfo = ByteUtil.concat(algorithmId, partyUInfo, partyVInfo, suppPubInfo, suppPrivInfo);
        return this.kdf(sharedSecret, keydatalen, otherInfo);
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] otherInfo) {
        long reps = this.getReps(keydatalen);
        log.debug("reps: {}", (Object)String.valueOf(reps));
        log.debug("otherInfo: {}", (Object)ByteUtil.toDebugString(otherInfo));
        ByteArrayOutputStream derivedByteOutputStream = new ByteArrayOutputStream();
        int i = 1;
        while ((long)i <= reps) {
            log.debug("rep {} hashing ", (Object)i);
            byte[] counterBytes = ByteUtil.getBytes(i);
            log.debug(" counter: {}", (Object)ByteUtil.toDebugString(counterBytes));
            log.debug(" z: {}", (Object)ByteUtil.toDebugString(sharedSecret));
            log.debug(" otherInfo: {}", (Object)ByteUtil.toDebugString(otherInfo));
            this.messageDigest.update(counterBytes);
            this.messageDigest.update(sharedSecret);
            this.messageDigest.update(otherInfo);
            byte[] digest = this.messageDigest.digest();
            log.debug(" k({}): {}", (Object)i, (Object)ByteUtil.toDebugString(digest));
            derivedByteOutputStream.write(digest, 0, digest.length);
            ++i;
        }
        int keyDateLenInBytes = ByteUtil.byteLength(keydatalen);
        byte[] derivedKeyMaterial = derivedByteOutputStream.toByteArray();
        log.debug("derived key material: {}", (Object)ByteUtil.toDebugString(derivedKeyMaterial));
        if (derivedKeyMaterial.length != keyDateLenInBytes) {
            byte[] newKeyMaterial = ByteUtil.subArray(derivedKeyMaterial, 0, keyDateLenInBytes);
            log.debug("first {} bits of derived key material: {}", (Object)keydatalen, (Object)ByteUtil.toDebugString(newKeyMaterial));
            derivedKeyMaterial = newKeyMaterial;
        }
        log.debug("final derived key material: {}", (Object)ByteUtil.toDebugString(derivedKeyMaterial));
        return derivedKeyMaterial;
    }

    long getReps(int keydatalen) {
        double repsD = (float)keydatalen / (float)this.digestLength;
        repsD = Math.ceil(repsD);
        return (int)repsD;
    }

    private MessageDigest getMessageDigest(String digestMethod) {
        try {
            return MessageDigest.getInstance(digestMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedJoseException("Must have " + digestMethod + " MessageDigest but don't.", e);
        }
    }
}

