/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.PackedObjectInfo;

public class ObjectToPack
extends PackedObjectInfo {
    private static final int REUSE_AS_IS = 1;
    private static final int DELTA_ATTEMPTED = 2;
    private static final int DO_NOT_DELTA = 4;
    private static final int EDGE = 8;
    private static final int ATTEMPT_DELTA_MASK = 3;
    private static final int TYPE_SHIFT = 5;
    private static final int EXT_SHIFT = 8;
    private static final int EXT_MASK = 15;
    private static final int DELTA_SHIFT = 12;
    private static final int NON_EXT_MASK = -3841;
    private static final int NON_DELTA_MASK = 4095;
    private ObjectId deltaBase;
    private int flags;
    private int pathHash;
    private DeltaCache.Ref cachedDelta;

    public ObjectToPack(AnyObjectId src, int type) {
        super(src);
        this.flags = type << 5;
    }

    public final ObjectId getDeltaBaseId() {
        return this.deltaBase;
    }

    public final ObjectToPack getDeltaBase() {
        if (this.deltaBase instanceof ObjectToPack) {
            return (ObjectToPack)this.deltaBase;
        }
        return null;
    }

    final void setDeltaBase(ObjectId deltaBase) {
        this.deltaBase = deltaBase;
    }

    final void setCachedDelta(DeltaCache.Ref data) {
        this.cachedDelta = data;
    }

    final DeltaCache.Ref popCachedDelta() {
        DeltaCache.Ref r = this.cachedDelta;
        if (r != null) {
            this.cachedDelta = null;
        }
        return r;
    }

    final void clearDeltaBase() {
        this.deltaBase = null;
        if (this.cachedDelta != null) {
            this.cachedDelta.clear();
            this.cachedDelta.enqueue();
            this.cachedDelta = null;
        }
    }

    public final boolean isDeltaRepresentation() {
        return this.deltaBase != null;
    }

    public final boolean isWritten() {
        return 1L < this.getOffset();
    }

    public final int getType() {
        return this.flags >> 5 & 7;
    }

    final int getDeltaDepth() {
        return this.flags >>> 12;
    }

    final void setDeltaDepth(int d) {
        this.flags = d << 12 | this.flags & 0xFFF;
    }

    final int getChainLength() {
        return this.getDeltaDepth();
    }

    final void setChainLength(int len) {
        this.setDeltaDepth(len);
    }

    final void clearChainLength() {
        this.flags &= 0xFFF;
    }

    final boolean wantWrite() {
        return this.getOffset() == 1L;
    }

    final void markWantWrite() {
        this.setOffset(1L);
    }

    public final boolean isReuseAsIs() {
        return (this.flags & 1) != 0;
    }

    final void setReuseAsIs() {
        this.flags |= 1;
    }

    protected void clearReuseAsIs() {
        this.flags &= 0xFFFFFFFE;
    }

    final boolean isDoNotDelta() {
        return (this.flags & 4) != 0;
    }

    final void setDoNotDelta() {
        this.flags |= 4;
    }

    final boolean isEdge() {
        return (this.flags & 8) != 0;
    }

    final void setEdge() {
        this.flags |= 8;
    }

    final boolean doNotAttemptDelta() {
        return (this.flags & 3) == 3;
    }

    final void setDeltaAttempted(boolean deltaAttempted) {
        this.flags = deltaAttempted ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    protected final int getExtendedFlags() {
        return this.flags >>> 8 & 0xF;
    }

    protected final boolean isExtendedFlag(int flag) {
        return (this.flags & flag << 8) != 0;
    }

    protected final void setExtendedFlag(int flag) {
        this.flags |= (flag & 0xF) << 8;
    }

    protected final void clearExtendedFlag(int flag) {
        this.flags &= ~((flag & 0xF) << 8);
    }

    protected final void setExtendedFlags(int extFlags) {
        this.flags = (extFlags & 0xF) << 8 | this.flags & 0xFFFFF0FF;
    }

    final int getFormat() {
        if (this.isReuseAsIs()) {
            if (this.isDeltaRepresentation()) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    final int getWeight() {
        return this.getCRC();
    }

    final void setWeight(int weight) {
        this.setCRC(weight);
    }

    final int getPathHash() {
        return this.pathHash;
    }

    final void setPathHash(int hc) {
        this.pathHash = hc;
    }

    final int getCachedSize() {
        return this.pathHash;
    }

    final void setCachedSize(int sz) {
        this.pathHash = sz;
    }

    public void select(StoredObjectRepresentation ref) {
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ObjectToPack[");
        buf.append(Constants.typeString(this.getType()));
        buf.append(" ");
        buf.append(this.name());
        if (this.wantWrite()) {
            buf.append(" wantWrite");
        }
        if (this.isReuseAsIs()) {
            buf.append(" reuseAsIs");
        }
        if (this.isDoNotDelta()) {
            buf.append(" doNotDelta");
        }
        if (this.isEdge()) {
            buf.append(" edge");
        }
        if (this.getDeltaDepth() > 0) {
            buf.append(" depth=").append(this.getDeltaDepth());
        }
        if (this.isDeltaRepresentation()) {
            if (this.getDeltaBase() != null) {
                buf.append(" base=inpack:").append(this.getDeltaBase().name());
            } else {
                buf.append(" base=edge:").append(this.getDeltaBaseId().name());
            }
        }
        if (this.isWritten()) {
            buf.append(" offset=").append(this.getOffset());
        }
        buf.append("]");
        return buf.toString();
    }
}

