/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.NoSuchOptionException;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.OptionsGroup;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.impl.verifier.ResultErrorHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SalesforceComponentVerifier
extends DefaultComponentVerifier {
    SalesforceComponentVerifier(SalesforceComponent component) {
        super("salesforce", component.getCamelContext());
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.PARAMETERS).errors(ResultErrorHelper.requiresAny(parameters, (OptionsGroup[])new OptionsGroup[]{OptionsGroup.withName((Enum)AuthenticationType.USERNAME_PASSWORD).options(new String[]{"clientId", "clientSecret", "userName", "password", "!refreshToken", "!keystore"}), OptionsGroup.withName((Enum)AuthenticationType.REFRESH_TOKEN).options(new String[]{"clientId", "clientSecret", "refreshToken", "!password", "!keystore"}), OptionsGroup.withName((Enum)AuthenticationType.JWT).options(new String[]{"clientId", "userName", "keystore", "!password", "!refreshToken"})}));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.CONNECTIVITY);
        try {
            SalesforceEndpointConfig configuration = new SalesforceEndpointConfig();
            this.setProperties(configuration, parameters);
            SalesforceLoginConfig loginConfig = new SalesforceLoginConfig();
            this.setProperties(loginConfig, parameters);
            SSLContextParameters contextParameters = new SSLContextParameters();
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setSslContext(contextParameters.createSSLContext(this.getCamelContext()));
            SalesforceHttpClient httpClient = new SalesforceHttpClient(sslContextFactory);
            httpClient.setConnectTimeout(60000L);
            this.configureHttpProxy(httpClient, parameters);
            SalesforceSession session = new SalesforceSession(this.getCamelContext(), httpClient, httpClient.getTimeout(), loginConfig);
            DefaultRestClient client = new DefaultRestClient(httpClient, configuration.getApiVersion(), configuration.getFormat(), session);
            httpClient.setSession(session);
            httpClient.start();
            session.start();
            client.start();
            client.getVersions((response, exception) -> this.processSalesforceException(builder, Optional.ofNullable(exception)));
            client.stop();
            session.stop();
            httpClient.stop();
            httpClient.destroy();
        }
        catch (NoSuchOptionException e) {
            builder.error(ResultErrorBuilder.withMissingOption((String)e.getOptionName()).build());
        }
        catch (SalesforceException e) {
            this.processSalesforceException(builder, Optional.of(e));
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }

    private void processSalesforceException(ResultBuilder builder, Optional<SalesforceException> exception) {
        exception.ifPresent(e -> {
            builder.error(ResultErrorBuilder.withException((Exception)((Object)e)).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_CODE, (Object)e.getStatusCode()).build());
            for (RestError error : e.getErrors()) {
                builder.error(ResultErrorBuilder.withCode((ComponentVerifier.VerificationError.Code)ComponentVerifier.VerificationError.StandardCode.GENERIC).description(error.getMessage()).parameterKeys(error.getFields()).detail("salesforce_code", (Object)error.getErrorCode()).build());
            }
        });
    }

    private void configureHttpProxy(SalesforceHttpClient httpClient, Map<String, Object> parameters) throws NoSuchOptionException, URISyntaxException {
        Optional httpProxyHost = this.getOption(parameters, "httpProxyHost", String.class);
        Optional httpProxyPort = this.getOption(parameters, "httpProxyPort", Integer.class);
        Optional httpProxyUsername = this.getOption(parameters, "httpProxyUsername", String.class);
        Optional httpProxyPassword = this.getOption(parameters, "httpProxyPassword", String.class);
        if (httpProxyHost.isPresent() && httpProxyPort.isPresent()) {
            Origin.Address address = new Origin.Address((String)httpProxyHost.get(), ((Integer)httpProxyPort.get()).intValue());
            Boolean isHttpProxySocks4 = (Boolean)this.getOption(parameters, "isHttpProxySocks4", Boolean.class, () -> false);
            Boolean isHttpProxySecure = (Boolean)this.getOption(parameters, "isHttpProxySecure", Boolean.class, () -> true);
            if (isHttpProxySocks4.booleanValue()) {
                httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(address, isHttpProxySecure.booleanValue()));
            } else {
                httpClient.getProxyConfiguration().getProxies().add(new HttpProxy(address, isHttpProxySecure.booleanValue()));
            }
        }
        if (httpProxyUsername.isPresent() && httpProxyPassword.isPresent()) {
            Boolean httpProxyUseDigestAuth = (Boolean)this.getOption(parameters, "httpProxyUseDigestAuth", Boolean.class, () -> false);
            String httpProxyAuthUri = (String)this.getMandatoryOption(parameters, "httpProxyAuthUri", String.class);
            String httpProxyRealm = (String)this.getMandatoryOption(parameters, "httpProxyRealm", String.class);
            if (httpProxyUseDigestAuth.booleanValue()) {
                httpClient.getAuthenticationStore().addAuthentication((Authentication)new DigestAuthentication(new URI(httpProxyAuthUri), httpProxyRealm, (String)httpProxyUsername.get(), (String)httpProxyPassword.get()));
            } else {
                httpClient.getAuthenticationStore().addAuthentication((Authentication)new BasicAuthentication(new URI(httpProxyAuthUri), httpProxyRealm, (String)httpProxyUsername.get(), (String)httpProxyPassword.get()));
            }
        }
    }
}

