/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mina2Helper {
    private static final Logger LOG = LoggerFactory.getLogger(Mina2Helper.class);

    private Mina2Helper() {
    }

    public static void writeBody(IoSession session, Object body, Exchange exchange) throws CamelExchangeException {
        WriteFuture future = session.write(body);
        LOG.trace("Waiting for write to complete for body: {} using session: {}", body, (Object)session);
        if (!future.awaitUninterruptibly(10000L)) {
            String message = "Cannot write body: " + body.getClass().getCanonicalName() + " using session: " + session;
            if (future.getException() != null) {
                throw new CamelExchangeException(message, exchange, future.getException());
            }
            throw new CamelExchangeException(message, exchange);
        }
    }
}

