/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonDoubleImpl
implements JsonNumber,
Serializable {
    private final double value;

    JsonDoubleImpl(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double value must not be NaN or Infinite");
        }
        this.value = value;
    }

    public boolean isIntegral() {
        return false;
    }

    public int intValue() {
        return (int)this.value;
    }

    public int intValueExact() {
        return this.intValue();
    }

    public long longValue() {
        return (long)this.value;
    }

    public long longValueExact() {
        return (long)this.value;
    }

    public BigInteger bigIntegerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return new BigDecimal(this.toString()).toBigIntegerExact();
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).doubleValue() == this.value;
    }
}

