/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmlrpc;

import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlRpcWriter
extends org.apache.xmlrpc.serializer.XmlRpcWriter {
    private static final Attributes ZERO_ATTRIBUTES = new AttributesImpl();
    private final ContentHandler handler;

    public XmlRpcWriter(XmlRpcStreamConfig pConfig, ContentHandler pHandler, TypeFactory pTypeFactory) {
        super(pConfig, pHandler, pTypeFactory);
        this.handler = pHandler;
    }

    public void writeRequest(XmlRpcStreamConfig config, XmlRpcRequest request) throws SAXException {
        this.handler.startDocument();
        boolean extensions = config.isEnabledForExtensions();
        if (extensions) {
            this.handler.startPrefixMapping("ex", "http://ws.apache.org/xmlrpc/namespaces/extensions");
        }
        this.handler.startElement("", "methodCall", "methodCall", ZERO_ATTRIBUTES);
        this.handler.startElement("", "methodName", "methodName", ZERO_ATTRIBUTES);
        String s = request.getMethodName();
        this.handler.characters(s.toCharArray(), 0, s.length());
        this.handler.endElement("", "methodName", "methodName");
        this.handler.startElement("", "params", "params", ZERO_ATTRIBUTES);
        int num = request.getParameterCount();
        for (int i = 0; i < num; ++i) {
            this.handler.startElement("", "param", "param", ZERO_ATTRIBUTES);
            this.writeValue(request.getParameter(i));
            this.handler.endElement("", "param", "param");
        }
        this.handler.endElement("", "params", "params");
        this.handler.endElement("", "methodCall", "methodCall");
        if (extensions) {
            this.handler.endPrefixMapping("ex");
        }
        this.handler.endDocument();
    }
}

