/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.Service;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.UserManagedCache;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheManager
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheManager.class);
    private final EhcacheConfiguration configuration;
    private final CacheManager cacheManager;
    private final ConcurrentMap<String, UserManagedCache<?, ?>> userCaches;
    private final boolean managed;

    public EhcacheManager(EhcacheConfiguration configuration) throws IOException {
        this(configuration.createCacheManager(), !configuration.hasCacheManager(), configuration);
    }

    public EhcacheManager(CacheManager cacheManager) {
        this(cacheManager, false, null);
    }

    public EhcacheManager(CacheManager cacheManager, boolean managed) {
        this(cacheManager, managed, null);
    }

    private EhcacheManager(CacheManager cacheManager, boolean managed, EhcacheConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.userCaches = new ConcurrentHashMap();
        this.managed = managed;
        this.configuration = configuration;
        ObjectHelper.notNull((Object)cacheManager, (String)"cacheManager");
    }

    public synchronized void start() throws Exception {
        if (this.managed) {
            this.cacheManager.init();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.managed) {
            this.cacheManager.close();
        }
        this.userCaches.values().forEach(UserManagedCache::close);
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) throws Exception {
        Cache cache = this.cacheManager.getCache(name, keyType, valueType);
        if (cache == null && this.configuration != null && this.configuration.isCreateCacheIfNotExist()) {
            CacheConfiguration cacheConfiguration = this.configuration.getConfiguration();
            cache = cacheConfiguration != null ? this.cacheManager.createCache(name, cacheConfiguration) : (Cache)this.userCaches.computeIfAbsent(name, key -> UserManagedCacheBuilder.newUserManagedCacheBuilder((Class)keyType, (Class)valueType).build(true));
        }
        return cache;
    }

    public Cache<?, ?> getCache(String name) throws Exception {
        return this.getCache(name, this.configuration.getKeyType(), this.configuration.getValueType());
    }

    public Cache<?, ?> getCache() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"Ehcache configuration");
        return this.getCache(this.configuration.getCacheName(), this.configuration.getKeyType(), this.configuration.getValueType());
    }
}

