/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.spi.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.service.WildFlyRuntimeFactory;

public class RuntimeService
extends AbstractService<Runtime> {
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private Runtime runtime;

    public ServiceController<Runtime> install(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.RUNTIME_SERVICE_NAME, (Service)this);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        DefaultPropertiesProvider propsProvider = new DefaultPropertiesProvider(this.initialProperties(), true);
        this.runtime = RuntimeLocator.createRuntime((RuntimeFactory)new WildFlyRuntimeFactory(), (PropertiesProvider)propsProvider);
        this.runtime.init();
    }

    public void stop(StopContext context) {
        try {
            this.runtime.shutdown();
            this.runtime.awaitShutdown(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            RuntimeLocator.releaseRuntime();
        }
    }

    public Runtime getValue() throws IllegalStateException {
        return this.runtime;
    }

    protected ServerEnvironment getServerEnvironment() {
        return (ServerEnvironment)this.injectedServerEnvironment.getValue();
    }

    protected Properties initialProperties() {
        Properties properties = new Properties();
        ServerEnvironment serverEnv = this.getServerEnvironment();
        File storageDir = new File(serverEnv.getServerDataDir(), "gravia-store");
        File configsDir = new File(serverEnv.getServerConfigurationDir(), "gravia" + File.separator + "configs");
        File repositoryDir = new File(serverEnv.getServerDataDir().getPath() + File.separator + "repository");
        properties.setProperty("org.jboss.gravia.runtime.storage.dir", storageDir.getAbsolutePath());
        properties.setProperty("org.jboss.gravia.runtime.configurations.dir", configsDir.getAbsolutePath());
        properties.setProperty("org.jboss.gravia.repository.storage.dir", repositoryDir.getAbsolutePath());
        properties.setProperty("org.jboss.gravia.runtime.type", RuntimeType.WILDFLY.toString());
        return properties;
    }
}

