/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Codec;
import zipkin.Span;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.Util;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public final class Collector {
    final Logger logger;
    final StorageComponent storage;
    final CollectorSampler sampler;
    final CollectorMetrics metrics;

    public static Builder builder(Class<?> loggingClass) {
        return new Builder(Logger.getLogger(Util.checkNotNull(loggingClass, "loggingClass").getName()));
    }

    Collector(Builder builder) {
        this.logger = Util.checkNotNull(builder.logger, "logger");
        this.storage = Util.checkNotNull(builder.storage, "storage");
        this.sampler = builder.sampler == null ? CollectorSampler.ALWAYS_SAMPLE : builder.sampler;
        this.metrics = builder.metrics == null ? CollectorMetrics.NOOP_METRICS : builder.metrics;
    }

    public void acceptSpans(byte[] serializedSpans, Codec codec, Callback<Void> callback) {
        List<Span> spans;
        this.metrics.incrementBytes(serializedSpans.length);
        try {
            spans = codec.readSpans(serializedSpans);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorReading(e));
            return;
        }
        this.accept(spans, callback);
    }

    public void acceptSpans(List<byte[]> serializedSpans, Codec codec, Callback<Void> callback) {
        ArrayList<Span> spans = new ArrayList<Span>(serializedSpans.size());
        try {
            int bytesRead = 0;
            for (byte[] serializedSpan : serializedSpans) {
                bytesRead += serializedSpan.length;
                spans.add(codec.readSpan(serializedSpan));
            }
            this.metrics.incrementBytes(bytesRead);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorReading(e));
            return;
        }
        this.accept(spans, callback);
    }

    public void accept(List<Span> spans, Callback<Void> callback) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        this.metrics.incrementSpans(spans.size());
        List<Span> sampled = this.sample(spans);
        if (sampled.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            this.storage.asyncSpanConsumer().accept(sampled, this.acceptSpansCallback(sampled));
            callback.onSuccess(null);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorStoringSpans(sampled, e));
            return;
        }
    }

    List<Span> sample(List<Span> input) {
        ArrayList<Span> sampled = new ArrayList<Span>(input.size());
        for (Span s : input) {
            if (!this.sampler.isSampled(s)) continue;
            sampled.add(s);
        }
        int dropped = input.size() - sampled.size();
        if (dropped > 0) {
            this.metrics.incrementSpansDropped(dropped);
        }
        return sampled;
    }

    Callback<Void> acceptSpansCallback(final List<Span> spans) {
        return new Callback<Void>(){

            @Override
            public void onSuccess(Void value) {
            }

            @Override
            public void onError(Throwable t) {
                Collector.this.errorStoringSpans(spans, t);
            }

            public String toString() {
                return Collector.appendSpanIds(spans, new StringBuilder("AcceptSpans(")).append(")").toString();
            }
        };
    }

    RuntimeException errorReading(Throwable e) {
        return this.errorReading("Cannot decode spans", e);
    }

    RuntimeException errorReading(String message, Throwable e) {
        this.metrics.incrementMessagesDropped();
        return this.doError(message, e);
    }

    RuntimeException errorStoringSpans(List<Span> spans, Throwable e) {
        this.metrics.incrementSpansDropped(spans.size());
        StringBuilder msg = Collector.appendSpanIds(spans, new StringBuilder("Cannot store spans "));
        return this.doError(msg.toString(), e);
    }

    RuntimeException doError(String message, Throwable e) {
        if (e instanceof RuntimeException && e.getMessage() != null && e.getMessage().startsWith("Malformed")) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return (RuntimeException)e;
        }
        message = String.format("%s due to %s(%s)", message, e.getClass().getSimpleName(), e.getMessage() == null ? "" : e.getMessage());
        this.logger.log(Level.WARNING, message, e);
        return new RuntimeException(message, e);
    }

    static StringBuilder appendSpanIds(List<Span> spans, StringBuilder message) {
        message.append("[");
        Iterator<Span> iterator = spans.iterator();
        while (iterator.hasNext()) {
            message.append(iterator.next().idString());
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]");
    }

    public static final class Builder {
        final Logger logger;
        StorageComponent storage = null;
        CollectorSampler sampler = CollectorSampler.ALWAYS_SAMPLE;
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;

        Builder(Logger logger) {
            this.logger = logger;
        }

        public Builder storage(StorageComponent storage) {
            this.storage = Util.checkNotNull(storage, "storage");
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = Util.checkNotNull(metrics, "metrics");
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.sampler = Util.checkNotNull(sampler, "sampler");
            return this;
        }

        public Collector build() {
            return new Collector(this);
        }
    }
}

