/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Node;
import zipkin.internal.Nullable;

public final class CorrectForClockSkew {
    public static List<Span> apply(List<Span> spans) {
        for (Span s : spans) {
            if (s.parentId != null) continue;
            Node<Span> tree = Node.constructTree(spans);
            CorrectForClockSkew.adjust(tree, null);
            ArrayList<Span> result = new ArrayList<Span>(spans.size());
            Iterator<Node<Span>> i = tree.traverse();
            while (i.hasNext()) {
                result.add(i.next().value());
            }
            return result;
        }
        return spans;
    }

    static void adjust(Node<Span> node, @Nullable ClockSkew skewFromParent) {
        ClockSkew skew;
        if (skewFromParent != null) {
            node.value(CorrectForClockSkew.adjustTimestamps(node.value(), skewFromParent));
        }
        if ((skew = CorrectForClockSkew.getClockSkew(node.value())) != null) {
            node.value(CorrectForClockSkew.adjustTimestamps(node.value(), skew));
        } else if (skewFromParent != null && CorrectForClockSkew.isLocalSpan(node.value())) {
            skew = skewFromParent;
        }
        for (Node<Span> child : node.children()) {
            CorrectForClockSkew.adjust(child, skew);
        }
    }

    static boolean isLocalSpan(Span span) {
        int i;
        Endpoint endPoint = null;
        int length = span.annotations.size();
        for (i = 0; i < length; ++i) {
            Annotation annotation = span.annotations.get(i);
            if (endPoint == null) {
                endPoint = annotation.endpoint;
            }
            if (endPoint == null || endPoint.equals(annotation.endpoint)) continue;
            return false;
        }
        length = span.binaryAnnotations.size();
        for (i = 0; i < length; ++i) {
            BinaryAnnotation binaryAnnotation = span.binaryAnnotations.get(i);
            if (endPoint == null) {
                endPoint = binaryAnnotation.endpoint;
            }
            if (endPoint == null || endPoint.equals(binaryAnnotation.endpoint)) continue;
            return false;
        }
        return true;
    }

    static Span adjustTimestamps(Span span, ClockSkew skew) {
        int i;
        ArrayList<Annotation> annotations = null;
        Long annotationTimestamp = null;
        int length = span.annotations.size();
        for (i = 0; i < length; ++i) {
            Annotation a = span.annotations.get(i);
            if (a.endpoint == null || !CorrectForClockSkew.ipsMatch(skew.endpoint, a.endpoint)) continue;
            if (annotations == null) {
                annotations = new ArrayList<Annotation>(span.annotations);
            }
            if (span.timestamp != null && a.timestamp == span.timestamp) {
                annotationTimestamp = a.timestamp;
            }
            annotations.set(i, a.toBuilder().timestamp(a.timestamp - skew.skew).build());
        }
        if (annotations != null) {
            Span.Builder builder = span.toBuilder().annotations(annotations);
            if (annotationTimestamp != null) {
                builder.timestamp(annotationTimestamp - skew.skew);
            }
            return builder.build();
        }
        length = span.binaryAnnotations.size();
        for (i = 0; i < length; ++i) {
            BinaryAnnotation b = span.binaryAnnotations.get(i);
            if (b.endpoint == null || !b.key.equals("lc") || !CorrectForClockSkew.ipsMatch(skew.endpoint, b.endpoint)) continue;
            return span.toBuilder().timestamp(span.timestamp - skew.skew).build();
        }
        return span;
    }

    static boolean ipsMatch(Endpoint skew, Endpoint that) {
        return skew.ipv6 != null && Arrays.equals(skew.ipv6, that.ipv6) || skew.ipv4 != 0 && skew.ipv4 == that.ipv4;
    }

    @Nullable
    static ClockSkew getClockSkew(Span span) {
        Endpoint client;
        Endpoint server;
        Map<String, Annotation> annotations = CorrectForClockSkew.asMap(span.annotations);
        Annotation clientSend = annotations.get("cs");
        Annotation clientRecv = annotations.get("cr");
        Annotation serverRecv = annotations.get("sr");
        Annotation serverSend = annotations.get("ss");
        if (clientSend == null || clientRecv == null || serverRecv == null || serverSend == null) {
            return null;
        }
        Endpoint endpoint = server = serverRecv.endpoint != null ? serverRecv.endpoint : serverSend.endpoint;
        if (server == null) {
            return null;
        }
        Endpoint endpoint2 = client = clientSend.endpoint != null ? clientSend.endpoint : clientRecv.endpoint;
        if (client == null) {
            return null;
        }
        if (CorrectForClockSkew.ipsMatch(server, client)) {
            return null;
        }
        long clientDuration = clientRecv.timestamp - clientSend.timestamp;
        long serverDuration = serverSend.timestamp - serverRecv.timestamp;
        if (clientDuration < serverDuration) {
            return null;
        }
        long latency = (clientDuration - serverDuration) / 2L;
        if (latency < 0L) {
            return null;
        }
        long skew = serverRecv.timestamp - latency - clientSend.timestamp;
        if (skew != 0L) {
            return new ClockSkew(server, skew);
        }
        return null;
    }

    static Map<String, Annotation> asMap(List<Annotation> annotations) {
        LinkedHashMap<String, Annotation> result = new LinkedHashMap<String, Annotation>(annotations.size());
        for (Annotation a : annotations) {
            result.put(a.value, a);
        }
        return result;
    }

    private CorrectForClockSkew() {
    }

    static class ClockSkew {
        final Endpoint endpoint;
        final long skew;

        public ClockSkew(Endpoint endpoint, long skew) {
            this.endpoint = endpoint;
            this.skew = skew;
        }
    }
}

