/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class DependencyLinkSpan {
    final TraceId traceId;
    @Nullable
    final Long parentId;
    final long id;
    final Kind kind;
    @Nullable
    final String service;
    @Nullable
    final String peerService;

    DependencyLinkSpan(TraceId traceId, Long parentId, long id, Kind kind, String service, String peerService) {
        this.traceId = traceId;
        this.parentId = parentId;
        this.id = id;
        this.kind = Util.checkNotNull(kind, "kind");
        this.service = service;
        this.peerService = peerService;
    }

    public String toString() {
        StringBuilder json = new StringBuilder();
        json.append("{\"traceId\": \"").append(Util.toLowerHex(this.traceId.hi, this.traceId.lo)).append('\"');
        if (this.parentId != null) {
            json.append(", \"parentId\": \"").append(Util.toLowerHex(this.parentId)).append('\"');
        }
        json.append(", \"id\": \"").append(Util.toLowerHex(this.id)).append('\"');
        json.append(", \"kind\": \"").append((Object)this.kind).append('\"');
        if (this.service != null) {
            json.append(", \"service\": \"").append(this.service).append('\"');
        }
        if (this.peerService != null) {
            json.append(", \"peerService\": \"").append(this.peerService).append('\"');
        }
        return json.append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DependencyLinkSpan) {
            DependencyLinkSpan that = (DependencyLinkSpan)o;
            return Util.equal(this.traceId, that.traceId) && Util.equal(this.parentId, that.parentId) && this.id == that.id;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.traceId.hashCode();
        h *= 1000003;
        h ^= this.parentId == null ? 0 : this.parentId.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.id >>> 32 ^ this.id));
        return h;
    }

    public static Builder builder(long traceIdHigh, long traceIdLow, Long parentId, long spanId) {
        return new Builder(new TraceId(traceIdHigh, traceIdLow), parentId, spanId);
    }

    public static DependencyLinkSpan from(Span s) {
        TraceId traceId = new TraceId(s.traceIdHigh, s.traceId);
        Builder linkSpan = new Builder(traceId, s.parentId, s.id);
        for (BinaryAnnotation binaryAnnotation : s.binaryAnnotations) {
            if (binaryAnnotation.key.equals("ca") && binaryAnnotation.endpoint != null) {
                linkSpan.caService(binaryAnnotation.endpoint.serviceName);
                continue;
            }
            if (!binaryAnnotation.key.equals("sa") || binaryAnnotation.endpoint == null) continue;
            linkSpan.saService(binaryAnnotation.endpoint.serviceName);
        }
        for (Annotation annotation : s.annotations) {
            if (annotation.value.equals("sr") && annotation.endpoint != null) {
                linkSpan.srService(annotation.endpoint.serviceName);
                continue;
            }
            if (!annotation.value.equals("cs") || annotation.endpoint == null) continue;
            linkSpan.csService(annotation.endpoint.serviceName);
        }
        return linkSpan.build();
    }

    public static final class Builder {
        final TraceId traceId;
        final Long parentId;
        final long spanId;
        String srService;
        String csService;
        String caService;
        String saService;

        Builder(TraceId traceId, Long parentId, long spanId) {
            this.traceId = traceId;
            this.spanId = spanId;
            this.parentId = parentId;
        }

        public Builder srService(String srService) {
            if ("".equals(srService)) {
                srService = null;
            }
            this.srService = srService;
            return this;
        }

        public Builder csService(String csService) {
            if ("".equals(csService)) {
                csService = null;
            }
            this.csService = csService;
            return this;
        }

        public Builder caService(String caService) {
            if ("".equals(caService)) {
                caService = null;
            }
            this.caService = caService;
            return this;
        }

        public Builder saService(String saService) {
            if ("".equals(saService)) {
                saService = null;
            }
            this.saService = saService;
            return this;
        }

        public DependencyLinkSpan build() {
            if (Util.equal(this.saService, this.caService)) {
                this.caService = null;
            }
            if (this.srService != null) {
                if (this.caService == null) {
                    this.caService = this.csService;
                }
                return new DependencyLinkSpan(this.traceId, this.parentId, this.spanId, Kind.SERVER, this.srService, this.caService);
            }
            if (this.saService != null) {
                return new DependencyLinkSpan(this.traceId, this.parentId, this.spanId, Kind.CLIENT, this.caService, this.saService);
            }
            return new DependencyLinkSpan(this.traceId, this.parentId, this.spanId, Kind.UNKNOWN, null, null);
        }
    }

    static enum Kind {
        CLIENT,
        SERVER,
        UNKNOWN;

    }

    static final class TraceId {
        final long hi;
        final long lo;

        TraceId(long hi, long lo) {
            this.hi = hi;
            this.lo = lo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TraceId) {
                TraceId that = (TraceId)o;
                return this.hi == that.hi && this.lo == that.lo;
            }
            return false;
        }

        public int hashCode() {
            int h = 1;
            h *= 1000003;
            h = (int)((long)h ^ (this.hi >>> 32 ^ this.hi));
            h *= 1000003;
            h = (int)((long)h ^ (this.lo >>> 32 ^ this.lo));
            return h;
        }
    }
}

