/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CallbackCaptor;
import zipkin.internal.Nullable;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;

final class InternalAsyncToBlockingSpanStoreAdapter
implements SpanStore {
    final AsyncSpanStore delegate;

    InternalAsyncToBlockingSpanStoreAdapter(AsyncSpanStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<List<Span>> getTraces(QueryRequest request) {
        CallbackCaptor<List<List<Span>>> captor = new CallbackCaptor<List<List<Span>>>();
        this.delegate.getTraces(request, captor);
        return captor.get();
    }

    @Override
    @Deprecated
    public List<Span> getTrace(long id) {
        return this.getTrace(0L, id);
    }

    @Override
    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        CallbackCaptor<List<Span>> captor = new CallbackCaptor<List<Span>>();
        this.delegate.getTrace(traceIdHigh, traceIdLow, captor);
        return captor.get();
    }

    @Override
    @Deprecated
    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public List<Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        CallbackCaptor<List<Span>> captor = new CallbackCaptor<List<Span>>();
        this.delegate.getRawTrace(traceIdHigh, traceIdLow, captor);
        return captor.get();
    }

    @Override
    public List<String> getServiceNames() {
        CallbackCaptor<List<String>> captor = new CallbackCaptor<List<String>>();
        this.delegate.getServiceNames(captor);
        return captor.get();
    }

    @Override
    public List<String> getSpanNames(String serviceName) {
        CallbackCaptor<List<String>> captor = new CallbackCaptor<List<String>>();
        this.delegate.getSpanNames(serviceName, captor);
        return captor.get();
    }

    @Override
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        CallbackCaptor<List<DependencyLink>> captor = new CallbackCaptor<List<DependencyLink>>();
        this.delegate.getDependencies(endTs, lookback, captor);
        return captor.get();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

