/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ClosedCallback;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.DisconnectedCallback;
import io.nats.client.ExceptionHandler;
import io.nats.client.ReconnectedCallback;
import io.nats.client.TcpConnectionFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class Options {
    String url;
    List<URI> servers;
    boolean noRandomize;
    final String connectionName;
    final boolean verbose;
    final boolean pedantic;
    final boolean secure;
    final SSLContext sslContext;
    final boolean tlsDebug;
    final boolean allowReconnect;
    final int maxReconnect;
    final long reconnectWait;
    final int connectionTimeout;
    final long pingInterval;
    final int maxPingsOut;
    public ClosedCallback closedCb;
    public DisconnectedCallback disconnectedCb;
    public ReconnectedCallback reconnectedCb;
    public ExceptionHandler asyncErrorCb;
    final int reconnectBufSize;
    final String username;
    final String password;
    final String token;
    final TcpConnectionFactory factory;

    private Options(Builder builder) {
        this.factory = builder.factory;
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.token = builder.token;
        if (builder.servers != null) {
            this.servers = new ArrayList<URI>(builder.servers);
        }
        this.noRandomize = builder.noRandomize;
        this.connectionName = builder.connectionName;
        this.verbose = builder.verbose;
        this.pedantic = builder.pedantic;
        this.secure = builder.secure;
        this.allowReconnect = builder.allowReconnect;
        this.maxReconnect = builder.maxReconnect;
        this.reconnectBufSize = builder.reconnectBufSize;
        this.reconnectWait = builder.reconnectWait;
        this.connectionTimeout = builder.connectionTimeout;
        this.pingInterval = builder.pingInterval;
        this.maxPingsOut = builder.maxPingsOut;
        this.sslContext = builder.sslContext;
        this.tlsDebug = builder.tlsDebug;
        this.disconnectedCb = builder.disconnectedCb;
        this.closedCb = builder.closedCb;
        this.reconnectedCb = builder.reconnectedCb;
        this.asyncErrorCb = builder.asyncErrorCb;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Options.compare(this.url, other.url) && Options.compare(this.username, other.username) && Options.compare(this.password, other.password) && Options.compare(this.token, other.token) && Options.compare(this.servers, other.servers) && Boolean.compare(this.noRandomize, other.noRandomize) == 0 && Options.compare(this.connectionName, other.connectionName) && Boolean.compare(this.verbose, other.verbose) == 0 && Boolean.compare(this.pedantic, other.pedantic) == 0 && Boolean.compare(this.secure, other.secure) == 0 && Boolean.compare(this.allowReconnect, other.allowReconnect) == 0 && Integer.compare(this.maxReconnect, other.maxReconnect) == 0 && Integer.compare(this.reconnectBufSize, other.reconnectBufSize) == 0 && Long.compare(this.reconnectWait, other.reconnectWait) == 0 && Integer.compare(this.connectionTimeout, other.connectionTimeout) == 0 && Long.compare(this.pingInterval, other.pingInterval) == 0 && Integer.compare(this.maxPingsOut, other.maxPingsOut) == 0 && (this.sslContext == null ? other.sslContext == null : this.sslContext.equals(other.sslContext)) && Boolean.compare(this.tlsDebug, other.tlsDebug) == 0 && (this.factory == null ? other.factory == null : this.factory == other.factory) && (this.disconnectedCb == null ? other.disconnectedCb == null : this.disconnectedCb == other.disconnectedCb) && (this.closedCb == null ? other.closedCb == null : this.closedCb == other.closedCb) && (this.reconnectedCb == null ? other.reconnectedCb == null : this.reconnectedCb == other.reconnectedCb) && (this.asyncErrorCb == null ? other.asyncErrorCb == null : this.asyncErrorCb == other.asyncErrorCb);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.username, this.password, this.token, this.servers, this.noRandomize, this.connectionName, this.verbose, this.pedantic, this.secure, this.allowReconnect, this.maxReconnect, this.reconnectBufSize, this.reconnectWait, this.connectionTimeout, this.pingInterval, this.maxPingsOut, this.sslContext, this.tlsDebug, this.factory, this.disconnectedCb, this.closedCb, this.reconnectedCb, this.asyncErrorCb);
    }

    static boolean compare(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    static boolean compare(List<URI> first, List<URI> second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            URI left = first.get(i);
            URI right = second.get(i);
            if (left != null ? left.equals(right) : right == null) continue;
            return false;
        }
        return true;
    }

    public Connection connect() throws IOException {
        return new ConnectionImpl(this).connect();
    }

    public TcpConnectionFactory getFactory() {
        return this.factory;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public List<URI> getServers() {
        return this.servers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isTlsDebug() {
        return this.tlsDebug;
    }

    public boolean isReconnectAllowed() {
        return this.allowReconnect;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public int getReconnectBufSize() {
        return this.reconnectBufSize;
    }

    public long getReconnectWait() {
        return this.reconnectWait;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.asyncErrorCb;
    }

    public ClosedCallback getClosedCallback() {
        return this.closedCb;
    }

    public ReconnectedCallback getReconnectedCallback() {
        return this.reconnectedCb;
    }

    public DisconnectedCallback getDisconnectedCallback() {
        return this.disconnectedCb;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static final class Builder {
        String url;
        List<URI> servers;
        private String username;
        private String password;
        private String token;
        private boolean noRandomize;
        private String connectionName;
        private boolean verbose;
        private boolean pedantic;
        private boolean secure;
        private boolean allowReconnect = true;
        private int maxReconnect = 60;
        private int reconnectBufSize = 0x800000;
        private long reconnectWait = 2000L;
        private int connectionTimeout = 2000;
        private long pingInterval = 120000L;
        private int maxPingsOut = 2;
        private SSLContext sslContext;
        private boolean tlsDebug;
        private TcpConnectionFactory factory;
        DisconnectedCallback disconnectedCb;
        ClosedCallback closedCb;
        ReconnectedCallback reconnectedCb;
        ExceptionHandler asyncErrorCb;

        public Builder(Options template) {
            this.url = template.url;
            this.username = template.username;
            this.password = template.password;
            this.token = template.token;
            if (template.servers != null) {
                this.servers = new ArrayList<URI>(template.servers);
            }
            this.noRandomize = template.noRandomize;
            this.connectionName = template.connectionName;
            this.verbose = template.verbose;
            this.pedantic = template.pedantic;
            this.secure = template.secure;
            this.allowReconnect = template.allowReconnect;
            this.maxReconnect = template.maxReconnect;
            this.reconnectBufSize = template.reconnectBufSize;
            this.reconnectWait = template.reconnectWait;
            this.connectionTimeout = template.connectionTimeout;
            this.pingInterval = template.pingInterval;
            this.maxPingsOut = template.maxPingsOut;
            this.sslContext = template.sslContext;
            this.tlsDebug = template.tlsDebug;
            this.disconnectedCb = template.disconnectedCb;
            this.closedCb = template.closedCb;
            this.reconnectedCb = template.reconnectedCb;
            this.asyncErrorCb = template.asyncErrorCb;
            this.factory = template.factory;
        }

        public Builder() {
        }

        public Builder(Properties props) {
            Object instance;
            Constructor<?> constructor;
            Class<?> clazz;
            String str;
            if (props == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            if (props.containsKey("io.nats.client.url")) {
                this.url = props.getProperty("io.nats.client.url", "nats://localhost:4222");
            }
            if (props.containsKey("io.nats.client.username")) {
                this.username = props.getProperty("io.nats.client.username", null);
            }
            if (props.containsKey("io.nats.client.password")) {
                this.password = props.getProperty("io.nats.client.password", null);
            }
            if (props.containsKey("io.nats.client.servers")) {
                String str2 = props.getProperty("io.nats.client.servers");
                if (str2.isEmpty()) {
                    throw new IllegalArgumentException("io.nats.client.servers cannot be empty");
                }
                String[] servers = str2.trim().split(",\\s*");
                this.servers = this.processServers(servers);
            }
            if (props.containsKey("io.nats.client.norandomize")) {
                this.noRandomize = Boolean.parseBoolean(props.getProperty("io.nats.client.norandomize"));
            }
            if (props.containsKey("io.nats.client.name")) {
                this.connectionName = props.getProperty("io.nats.client.name", null);
            }
            if (props.containsKey("io.nats.client.verbose")) {
                this.verbose = Boolean.parseBoolean(props.getProperty("io.nats.client.verbose"));
            }
            if (props.containsKey("io.nats.client.pedantic")) {
                this.pedantic = Boolean.parseBoolean(props.getProperty("io.nats.client.pedantic"));
            }
            if (props.containsKey("io.nats.client.secure")) {
                this.secure = Boolean.parseBoolean(props.getProperty("io.nats.client.secure"));
            }
            if (props.containsKey("io.nats.client.tls.debug")) {
                this.tlsDebug = Boolean.parseBoolean(props.getProperty("io.nats.client.tls.debug"));
            }
            if (props.containsKey("io.nats.client.reconnect.allowed")) {
                this.allowReconnect = Boolean.parseBoolean(props.getProperty("io.nats.client.reconnect.allowed", Boolean.toString(true)));
            }
            if (props.containsKey("io.nats.client.reconnect.max")) {
                this.maxReconnect = Integer.parseInt(props.getProperty("io.nats.client.reconnect.max", Integer.toString(60)));
            }
            if (props.containsKey("io.nats.client.reconnect.wait")) {
                this.reconnectWait = Integer.parseInt(props.getProperty("io.nats.client.reconnect.wait", Integer.toString(2000)));
            }
            if (props.containsKey("io.nats.client.reconnect.buffer.size")) {
                this.reconnectBufSize = Integer.parseInt(props.getProperty("io.nats.client.reconnect.buffer.size", Integer.toString(0x800000)));
            }
            if (props.containsKey("io.nats.client.timeout")) {
                this.connectionTimeout = Integer.parseInt(props.getProperty("io.nats.client.timeout", Integer.toString(2000)));
            }
            if (props.containsKey("io.nats.client.pinginterval")) {
                this.pingInterval = Integer.parseInt(props.getProperty("io.nats.client.pinginterval", Integer.toString(120000)));
            }
            if (props.containsKey("io.nats.client.maxpings")) {
                this.maxPingsOut = Integer.parseInt(props.getProperty("io.nats.client.maxpings", Integer.toString(2)));
            }
            if (props.containsKey("io.nats.client.callback.exception")) {
                try {
                    str = props.getProperty("io.nats.client.callback.exception");
                    clazz = Class.forName(str);
                    constructor = clazz.getConstructor(new Class[0]);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                this.asyncErrorCb = (ExceptionHandler)instance;
            }
            if (props.containsKey("io.nats.client.callback.closed")) {
                try {
                    str = props.getProperty("io.nats.client.callback.closed");
                    clazz = Class.forName(str);
                    constructor = clazz.getConstructor(new Class[0]);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                this.closedCb = (ClosedCallback)instance;
            }
            if (props.containsKey("io.nats.client.callback.disconnected")) {
                try {
                    str = props.getProperty("io.nats.client.callback.disconnected");
                    clazz = Class.forName(str);
                    constructor = clazz.getConstructor(new Class[0]);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                this.disconnectedCb = (DisconnectedCallback)instance;
            }
            if (props.containsKey("io.nats.client.callback.reconnected")) {
                try {
                    str = props.getProperty("io.nats.client.callback.reconnected");
                    clazz = Class.forName(str);
                    constructor = clazz.getConstructor(new Class[0]);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                this.reconnectedCb = (ReconnectedCallback)instance;
            }
        }

        public Builder dontRandomize() {
            this.noRandomize = true;
            return this;
        }

        Builder factory(TcpConnectionFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder maxPingsOut(int maxPingsOut) {
            this.maxPingsOut = maxPingsOut;
            return this;
        }

        public Builder maxReconnect(int maxReconnect) {
            this.maxReconnect = maxReconnect;
            return this;
        }

        public Builder name(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public Builder pedantic() {
            this.pedantic = true;
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            return this.pingInterval(unit.toMillis(interval));
        }

        public Builder pingInterval(long pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        public Builder noReconnect() {
            this.allowReconnect = false;
            return this;
        }

        public Builder reconnectBufSize(int reconnectBufSize) {
            this.reconnectBufSize = reconnectBufSize;
            return this;
        }

        public Builder reconnectWait(long millis) {
            this.reconnectWait = millis;
            return this;
        }

        public Builder reconnectWait(long duration, TimeUnit unit) {
            return this.reconnectWait(unit.toMillis(duration));
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        List<URI> processServers(String[] serverArray) {
            ArrayList<URI> list = null;
            if (serverArray != null && serverArray.length != 0) {
                list = new ArrayList<URI>(serverArray.length);
                for (String s : serverArray) {
                    if (s == null || s.isEmpty()) continue;
                    try {
                        list.add(new URI(s.trim()));
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException("Bad server URL: " + s, e);
                    }
                }
            }
            return list;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            if (sslContext != null) {
                this.secure = true;
            }
            return this;
        }

        public Builder timeout(int millis) {
            this.connectionTimeout = millis;
            return this;
        }

        public Builder timeout(int timeout, TimeUnit unit) {
            return this.timeout((int)unit.toMillis(timeout));
        }

        public Builder tlsDebug() {
            this.tlsDebug = true;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder userInfo(String user, String pass) {
            this.username = user;
            this.password = pass;
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder errorCb(ExceptionHandler cb) {
            this.asyncErrorCb = cb;
            return this;
        }

        public Builder closedCb(ClosedCallback cb) {
            this.closedCb = cb;
            return this;
        }

        public Builder disconnectedCb(DisconnectedCallback cb) {
            this.disconnectedCb = cb;
            return this;
        }

        public Builder reconnectedCb(ReconnectedCallback cb) {
            this.reconnectedCb = cb;
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

