/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.SubscriptionImpl;
import io.nats.client.SyncSubscription;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class SyncSubscriptionImpl
extends SubscriptionImpl
implements SyncSubscription {
    private final Map<Long, Thread> threads = new ConcurrentHashMap<Long, Thread>();

    SyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue) {
        super(nc, subj, queue);
    }

    @Override
    public void close() {
        this.lock();
        try {
            for (Map.Entry<Long, Thread> entry : this.threads.entrySet()) {
                if (entry.getKey().longValue() == Thread.currentThread().getId()) continue;
                entry.getValue().interrupt();
            }
        }
        finally {
            this.unlock();
        }
        super.close();
    }

    @Override
    public Message nextMessage() throws IOException, InterruptedException {
        return this.nextMessage(-1L);
    }

    @Override
    public Message nextMessage(long timeout) throws IOException, InterruptedException {
        return this.nextMessage(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message nextMessage(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        this.lock();
        if (this.connClosed) {
            this.unlock();
            throw new IllegalStateException("nats: connection closed");
        }
        if (this.mch == null) {
            if (this.max > 0L && this.delivered >= this.max) {
                this.unlock();
                throw new IOException("nats: maximum messages delivered");
            }
            if (this.closed) {
                this.unlock();
                throw new IllegalStateException("nats: invalid subscription");
            }
        }
        if (this.sc) {
            this.sc = false;
            this.unlock();
            throw new IOException("nats: slow consumer, messages dropped");
        }
        ConnectionImpl nc = (ConnectionImpl)this.getConnection();
        BlockingQueue localChannel = this.mch;
        long localMax = this.max;
        this.unlock();
        Message msg = null;
        this.threads.put(Thread.currentThread().getId(), Thread.currentThread());
        try {
            if (localChannel == null) {
                throw new IllegalStateException("nats: connection closed");
            }
            msg = timeout >= 0L ? (Message)localChannel.poll(timeout, unit) : (Message)localChannel.take();
        }
        finally {
            this.threads.remove(Thread.currentThread().getId());
        }
        if (msg != null) {
            long delivered;
            this.lock();
            try {
                ++this.delivered;
                delivered = this.delivered;
                --this.pMsgs;
                this.pBytes -= msg.getData() != null ? msg.getData().length : 0;
            }
            finally {
                this.unlock();
            }
            if (localMax > 0L) {
                if (delivered > localMax) {
                    throw new IOException("nats: maximum messages delivered");
                }
                if (delivered == localMax) {
                    nc.mu.lock();
                    try {
                        nc.removeSub(this);
                    }
                    finally {
                        nc.mu.unlock();
                    }
                }
            }
        }
        return msg;
    }
}

