/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Command {
    private String appName;
    private Options rules = new Options();
    public String[] args = new String[0];
    public HashMap<String, Object> opts = new HashMap();
    public Boolean help = false;
    public static final HashMap<String, Object> defaultValues = new HashMap();

    Command(String string) {
        defaultValues.put("scheme", "https");
        defaultValues.put("host", "localhost");
        defaultValues.put("port", 8089);
        this.appName = string;
    }

    public static Command create() {
        return Command.create(null);
    }

    public static Command create(String string) {
        return new Command(string);
    }

    public static void error(String string, Object ... objectArray) {
        System.err.format("Error: %s\n", String.format(string, objectArray));
        System.exit(2);
    }

    public Options getRules() {
        return this.rules;
    }

    public Command init() {
        this.rules.addOption("h", "help", false, "Display this help message");
        this.rules.addOption(null, "host", true, "Host name (default localhost)");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withType(Integer.class);
        this.rules.addOption(OptionBuilder.create());
        this.rules.addOption(null, "scheme", true, "Scheme (default https)");
        this.rules.addOption(null, "username", true, "Username to login with");
        this.rules.addOption(null, "password", true, "Password to login with");
        this.rules.addOption(null, "app", true, "App/namespace context");
        this.rules.addOption(null, "owner", true, "Owner/user context");
        this.rules.addOption(null, "version", true, "Version (irrelevant for Java)");
        return this;
    }

    public Command addRule(String string, String string2) {
        this.rules.addOption(null, string, false, string2);
        return this;
    }

    public Command addRule(String string, Class clazz, String string2) {
        OptionBuilder.withLongOpt((String)string);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withType((Object)clazz);
        OptionBuilder.withDescription((String)string2);
        this.rules.addOption(OptionBuilder.create());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command load(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            FileReader fileReader = new FileReader(string);
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#") || (string2 = string2.trim()).length() == 0) continue;
                    if (!string2.startsWith("-")) {
                        string2 = "--" + string2;
                    }
                    arrayList.add(string2);
                }
            }
            finally {
                fileReader.close();
            }
        }
        catch (IOException iOException) {
            Command.error(iOException.getMessage(), new Object[0]);
            return this;
        }
        this.parse(arrayList.toArray(new String[arrayList.size()]));
        return this;
    }

    public Command parse(String[] stringArray) {
        PosixParser posixParser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = posixParser.parse(this.rules, stringArray);
        }
        catch (ParseException parseException) {
            Command.error(parseException.getMessage(), new Object[0]);
        }
        for (Option option : commandLine.getOptions()) {
            AnnotatedElement noSuchFieldException;
            String string = option.getLongOpt();
            Object object = option.getValue();
            if (!option.hasArg()) {
                object = true;
            } else {
                noSuchFieldException = (Class)option.getType();
                if (noSuchFieldException != null) {
                    if (noSuchFieldException == Integer.class) {
                        object = Integer.parseInt((String)object);
                    } else assert (false);
                }
            }
            this.opts.put(string, object);
            try {
                noSuchFieldException = this.getClass().getField(string);
                ((Field)noSuchFieldException).set(this, object);
            }
            catch (NoSuchFieldException illegalAccessException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
            }
        }
        String[] stringArray2 = this.args;
        String[] stringArray3 = commandLine.getArgs();
        this.args = new String[stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray2, 0, this.args, 0, stringArray2.length);
        System.arraycopy(stringArray3, 0, this.args, stringArray2.length, stringArray3.length);
        if (this.help.booleanValue()) {
            this.printHelp();
            System.exit(0);
        }
        return this;
    }

    public void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String string = this.appName == null ? "App" : this.appName;
        helpFormatter.printHelp(string, this.rules);
    }

    public static Command splunk() {
        return Command.splunk(null);
    }

    public static Command splunk(String string) {
        return Command.create(string).init().splunkrc();
    }

    public Command splunkrc() {
        this.opts.putAll(defaultValues);
        this.load(System.getProperty("user.home") + File.separator + ".splunkrc");
        return this;
    }
}

