/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.AtomEntry;
import com.splunk.AtomFeed;
import com.splunk.AtomObject;
import com.splunk.EntityMetadata;
import com.splunk.Record;
import com.splunk.Resource;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.Value;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Entity
extends Resource
implements Map<String, Object> {
    protected Record content;
    protected HashMap<String, Object> toUpdate = new LinkedHashMap<String, Object>();

    public Entity(Service service, String path) {
        super(service, path);
    }

    protected String actionPath(String action) {
        if (action.equals("disable")) {
            return this.path + "/disable";
        }
        if (action.equals("edit")) {
            return this.path;
        }
        if (action.equals("enable")) {
            return this.path + "/enable";
        }
        if (action.equals("remove")) {
            return this.path;
        }
        throw new IllegalArgumentException("Invalid action: " + action);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getContent().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getContent().containsValue(value);
    }

    public void disable() {
        this.service.post(this.actionPath("disable"));
        this.invalidate();
    }

    public void enable() {
        this.service.post(this.actionPath("enable"));
        this.invalidate();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getContent().entrySet();
    }

    @Override
    public Object get(Object key) {
        if (this.toUpdate.containsKey(key)) {
            return this.toUpdate.get(key);
        }
        return this.getContent().get(key);
    }

    boolean getBoolean(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toBoolean(this.toUpdate.get(key).toString());
        }
        return this.getContent().getBoolean(key);
    }

    boolean getBoolean(String key, boolean defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toBoolean(this.toUpdate.get(key).toString());
        }
        return this.getContent().getBoolean(key, defaultValue);
    }

    long getByteCount(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toByteCount(this.toUpdate.get(key).toString());
        }
        return this.getContent().getByteCount(key);
    }

    long getByteCount(String key, long defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toByteCount(this.toUpdate.get(key).toString());
        }
        return this.getContent().getByteCount(key, defaultValue);
    }

    protected Record getContent() {
        return this.validate().content;
    }

    Date getDate(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toDate(this.toUpdate.get(key).toString());
        }
        if (this.getContent().containsKey(key)) {
            return this.getContent().getDate(key);
        }
        return null;
    }

    Date getDate(String key, Date defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toDate(this.toUpdate.get(key).toString());
        }
        return this.getContent().getDate(key, defaultValue);
    }

    float getFloat(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toFloat(this.toUpdate.get(key).toString());
        }
        return this.getContent().getFloat(key);
    }

    int getInteger(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toInteger(this.toUpdate.get(key).toString());
        }
        return this.getContent().getInteger(key);
    }

    int getInteger(String key, int defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toInteger(this.toUpdate.get(key).toString());
        }
        return this.getContent().getInteger(key, defaultValue);
    }

    long getLong(String key) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toLong(this.toUpdate.get(key).toString());
        }
        return this.getContent().getLong(key);
    }

    long getLong(String key, int defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return Value.toLong(this.toUpdate.get(key).toString());
        }
        return this.getContent().getLong(key, defaultValue);
    }

    public EntityMetadata getMetadata() {
        if (!this.containsKey("eai:acl")) {
            return null;
        }
        return new EntityMetadata(this);
    }

    String getString(String key) {
        if (this.toUpdate.containsKey(key)) {
            return this.toUpdate.get(key).toString();
        }
        return this.getContent().getString(key);
    }

    String getString(String key, String defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return this.toUpdate.get(key).toString();
        }
        return this.getContent().getString(key, defaultValue);
    }

    String[] getStringArray(String key) {
        if (this.toUpdate.containsKey(key)) {
            return ((String)this.toUpdate.get(key)).split("\\|");
        }
        return this.getContent().getStringArray(key);
    }

    String[] getStringArray(String key, String[] defaultValue) {
        if (this.toUpdate.containsKey(key)) {
            return this.getStringArray(key);
        }
        return this.getContent().getStringArray(key, defaultValue);
    }

    @Override
    public boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    public boolean isDisabled() {
        return this.getBoolean("disabled", false);
    }

    protected boolean isNameChangeAllowed() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return this.getContent().keySet();
    }

    @Override
    Entity load(AtomObject value) {
        super.load(value);
        AtomEntry entry = (AtomEntry)value;
        this.content = entry == null ? new Record() : entry.content;
        return this;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Entity refresh() {
        AtomFeed feed;
        ResponseMessage response = this.service.get(this.path);
        assert (response.getStatus() == 200);
        try {
            feed = AtomFeed.parseStream(response.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int count = feed.entries.size();
        if (count > 1) {
            throw new IllegalStateException("Expected 0 or 1 Atom entries; found " + feed.entries.size());
        }
        AtomEntry entry = count == 0 ? null : feed.entries.get(0);
        this.load(entry);
        return this;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    void setCacheValue(String key, Object value) {
        this.toUpdate.put(key, value);
    }

    @Override
    public int size() {
        return this.getContent().size();
    }

    public void update(Map<String, Object> args) {
        if (!this.toUpdate.isEmpty() || !args.isEmpty()) {
            LinkedHashMap<String, Object> mergedArgs = new LinkedHashMap<String, Object>();
            mergedArgs.putAll(this.toUpdate);
            mergedArgs.putAll(args);
            if (mergedArgs.containsKey("name") && !this.isNameChangeAllowed()) {
                throw new IllegalStateException("Cannot set 'name' on an existing entity.");
            }
            this.service.post(this.actionPath("edit"), mergedArgs);
            this.toUpdate.clear();
            this.invalidate();
        }
    }

    public void update() {
        this.update(Collections.EMPTY_MAP);
    }

    public void remove() {
        this.service.delete(this.actionPath("remove"));
    }

    @Override
    public Entity validate() {
        super.validate();
        return this;
    }

    @Override
    public Collection<Object> values() {
        return this.getContent().values();
    }
}

