/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomEntry;
import com.splunk.AtomFeed;
import com.splunk.EntityCollection;
import com.splunk.HttpException;
import com.splunk.Input;
import com.splunk.InputKind;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.SplunkException;
import com.splunk.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InputCollection
extends EntityCollection<Input> {
    protected Set<InputKind> inputKinds = new HashSet<InputKind>();

    InputCollection(Service service) {
        super(service, "data/inputs");
    }

    InputCollection(Service service, Args args) {
        super(service, "data/inputs", args);
    }

    @Override
    public boolean containsKey(Object key) {
        Input input = this.retrieveInput((String)key);
        return input != null;
    }

    @Override
    public Input create(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Input create(String name, Map args) {
        throw new UnsupportedOperationException();
    }

    public <T extends Input> T create(String name, InputKind kind) {
        return this.create(name, kind, null);
    }

    public <T extends Input> T create(String name, InputKind kind, Map<String, Object> args) {
        args = Args.create(args).add("name", name);
        String path = this.path + "/" + kind.getRelativePath();
        this.service.post(path, args);
        this.invalidate();
        return (T)this.get(name);
    }

    @Override
    protected Input createItem(AtomEntry entry) {
        String path = this.itemPath(entry);
        InputKind kind = this.itemKind(path);
        Class<? extends Input> inputClass = kind.getInputClass();
        return (Input)this.createItem(inputClass, path, null);
    }

    @Override
    public Input get(Object key) {
        return this.retrieveInput((String)key);
    }

    @Override
    public Input get(Object key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        return this.retrieveInput((String)key, namespace);
    }

    protected InputKind itemKind(String path) {
        String relpathWithInputName = Util.substringAfter(path, "/data/inputs/", null);
        for (InputKind kind : this.inputKinds) {
            if (!relpathWithInputName.startsWith(kind.getRelativePath())) continue;
            return kind;
        }
        return InputKind.Unknown;
    }

    public Set<InputKind> getInputKinds() {
        return this.inputKinds;
    }

    protected static boolean matchesInputName(InputKind kind, String searchFor, String searchIn) {
        if (kind == InputKind.Script) {
            return searchIn.endsWith("/" + searchFor) || searchIn.endsWith("\\" + searchFor);
        }
        return searchFor.equals(searchIn);
    }

    private Set<InputKind> assembleInputKindSet(List<String> subPath) {
        HashSet<InputKind> kinds = new HashSet<InputKind>();
        ResponseMessage response = this.service.get(this.path + "/" + Util.join("/", subPath));
        AtomFeed feed = AtomFeed.parseStream(response.getContent());
        for (AtomEntry entry : feed.entries) {
            String itemKeyName = this.itemKey(entry);
            boolean hasCreateLink = false;
            for (String linkName : entry.links.keySet()) {
                if (!linkName.equals("create")) continue;
                hasCreateLink = true;
            }
            ArrayList<String> thisSubPath = new ArrayList<String>(subPath);
            thisSubPath.add(itemKeyName);
            String relpath = Util.join("/", thisSubPath);
            if (relpath.equals("all") || relpath.equals("tcp/ssl")) continue;
            if (hasCreateLink) {
                InputKind newKind = InputKind.create(relpath);
                kinds.add(newKind);
                continue;
            }
            Set<InputKind> subKinds = this.assembleInputKindSet(thisSubPath);
            kinds.addAll(subKinds);
        }
        return kinds;
    }

    private void refreshInputKinds() {
        Set<InputKind> kinds = this.assembleInputKindSet(new ArrayList<String>());
        this.inputKinds.clear();
        this.inputKinds.addAll(kinds);
    }

    @Override
    public InputCollection refresh() {
        this.refreshInputKinds();
        this.items.clear();
        for (InputKind kind : this.inputKinds) {
            AtomFeed feed;
            ResponseMessage response;
            if (this.service.versionIsAtLeast("6.0.0") && kind.getKind().equals("registry")) continue;
            String relpath = kind.getRelativePath();
            String inputs = String.format("%s/%s?count=-1", this.path, relpath);
            try {
                response = this.service.get(inputs);
            }
            catch (HttpException e) {
                if (e.getStatus() == 404) continue;
                throw e;
            }
            try {
                feed = AtomFeed.parseStream(response.getContent());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.load(feed);
        }
        return this;
    }

    @Override
    public Input remove(String key) {
        Input input = this.retrieveInput(key);
        if (input != null) {
            input.remove();
        }
        return input;
    }

    @Override
    public Input remove(String key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        Input input = this.retrieveInput(key, namespace);
        if (input != null) {
            input.remove();
        }
        return input;
    }

    private Input retrieveInput(String key) {
        this.validate();
        Set set = this.items.entrySet();
        for (Map.Entry entry : set) {
            String entryKey = (String)entry.getKey();
            LinkedList entryValue = (LinkedList)entry.getValue();
            InputKind kind = ((Input)entryValue.get(0)).getKind();
            if (!InputCollection.matchesInputName(kind, key, entryKey)) continue;
            if (entryValue.size() > 1) {
                throw new SplunkException(3, "Multiple inputs matched " + key + "; specify a namespace to disambiguate.");
            }
            return (Input)entryValue.get(0);
        }
        return null;
    }

    private Input retrieveInput(String key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        this.validate();
        String pathMatcher = this.service.fullpath("", namespace);
        Set set = this.items.entrySet();
        for (Map.Entry entry : set) {
            String entryKey = (String)entry.getKey();
            LinkedList entryValue = (LinkedList)entry.getValue();
            InputKind kind = ((Input)entryValue.get(0)).getKind();
            if (!InputCollection.matchesInputName(kind, key, entryKey)) continue;
            for (Input entity : entryValue) {
                if (!entity.path.startsWith(pathMatcher)) continue;
                return entity;
            }
        }
        return null;
    }
}

