/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Input;
import com.splunk.MonitorInput;
import com.splunk.ScriptInput;
import com.splunk.TcpInput;
import com.splunk.TcpSplunkInput;
import com.splunk.UdpInput;
import com.splunk.WindowsActiveDirectoryInput;
import com.splunk.WindowsEventLogInput;
import com.splunk.WindowsPerfmonInput;
import com.splunk.WindowsRegistryInput;
import com.splunk.WindowsWmiInput;
import java.util.HashMap;
import java.util.Map;

public class InputKind {
    private String kind;
    private String relpath;
    private Class<? extends Input> inputClass;
    private static Map<String, InputKind> knownRelpaths = new HashMap<String, InputKind>();
    public static final InputKind Unknown = new InputKind(null, Input.class, "unknown");
    public static final InputKind Monitor = new InputKind("monitor", MonitorInput.class);
    public static final InputKind Script = new InputKind("script", ScriptInput.class);
    public static final InputKind Tcp = new InputKind("tcp/raw", TcpInput.class, "tcp");
    public static final InputKind TcpSplunk = new InputKind("tcp/cooked", TcpSplunkInput.class);
    public static final InputKind Udp = new InputKind("udp", UdpInput.class);
    public static final InputKind WindowsActiveDirectory = new InputKind("ad", WindowsActiveDirectoryInput.class);
    public static final InputKind WindowsEventLog = new InputKind("win-event-log-collections", WindowsEventLogInput.class);
    public static final InputKind WinEventLog = new InputKind("WinEventLog", WindowsEventLogInput.class);
    public static final InputKind WindowsPerfmon = new InputKind("win-perfmon", WindowsPerfmonInput.class);
    public static final InputKind WindowsRegistry = new InputKind("registry", WindowsRegistryInput.class);
    public static final InputKind WinRegMon = new InputKind("WinRegMon", WindowsRegistryInput.class);
    public static final InputKind WindowsWmi = new InputKind("win-wmi-collections", WindowsWmiInput.class);

    private InputKind(String relpath, Class<? extends Input> inputClass, String kind) {
        this.relpath = relpath;
        this.inputClass = inputClass;
        this.kind = kind;
        knownRelpaths.put(relpath, this);
    }

    private InputKind(String relpath, Class<? extends Input> inputClass) {
        this(relpath, inputClass, relpath);
    }

    String getKind() {
        return this.kind;
    }

    String getRelativePath() {
        return this.relpath;
    }

    Class<? extends Input> getInputClass() {
        return this.inputClass;
    }

    public static InputKind create(String relpath) {
        if (knownRelpaths.containsKey(relpath)) {
            return knownRelpaths.get(relpath);
        }
        return new InputKind(relpath, Input.class);
    }

    public String toString() {
        return this.relpath;
    }
}

