/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.server.session.ServerSession;

public class ServerConnectionService
extends AbstractConnectionService {
    protected ServerConnectionService(Session s) throws SshException {
        super(s);
        if (!(s instanceof ServerSession)) {
            throw new IllegalStateException("Server side service used on client side");
        }
        ServerSession session = (ServerSession)s;
        if (!session.isAuthenticated()) {
            throw new SshException("Session is not authenticated");
        }
    }

    public String initAgentForward() throws IOException {
        return this.agentForward.initialize();
    }

    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        return this.x11Forward.createDisplay(singleConnection, authenticationProtocol, authenticationCookie, screen);
    }

    public static class Factory
    implements ServiceFactory {
        public String getName() {
            return "ssh-connection";
        }

        public Service create(Session session) throws IOException {
            return new ServerConnectionService(session);
        }
    }
}

