/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.converter;

import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationMessage;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.GenericMessage;

@Converter
public final class SpringIntegrationConverter {
    private SpringIntegrationConverter() {
    }

    @Converter
    public static Endpoint toEndpoint(MessageChannel channel) throws Exception {
        SpringIntegrationEndpoint answer = new SpringIntegrationEndpoint("spring-integration://" + channel.toString(), channel, null);
        return answer;
    }

    @Converter
    public static org.springframework.messaging.Message<?> toSpringMessage(Message camelMessage) throws Exception {
        SpringIntegrationMessage siMessage;
        org.springframework.messaging.Message<?> message;
        if (camelMessage instanceof SpringIntegrationMessage && (message = (siMessage = (SpringIntegrationMessage)camelMessage).getMessage()) != null) {
            return message;
        }
        MessageHeaders messageHeaders = new MessageHeaders(camelMessage.getHeaders());
        return new GenericMessage(camelMessage.getBody(), messageHeaders);
    }

    @Converter
    public static Message toCamelMessage(org.springframework.messaging.Message<?> springMessage) throws Exception {
        return new SpringIntegrationMessage(springMessage);
    }
}

