/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;

public class OriginTracer
implements MessageInterceptor {
    private static final Logger LOGGER = Logger.getLogger(OriginTracer.class.getCanonicalName());
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss]");

    @Override
    public void receiveRequest(Request request) {
        LOGGER.log(Level.INFO, "{0}", request.getSource());
    }

    @Override
    public void sendRequest(Request request) {
    }

    @Override
    public void sendResponse(Response response) {
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
    }

    @Override
    public void receiveResponse(Response response) {
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        if (message.getType() == CoAP.Type.CON) {
            LOGGER.log(Level.INFO, "{0}", message.getSource());
        }
    }

    static {
        try {
            String month = new SimpleDateFormat("yyyy-MM").format(new Date());
            final FileHandler fh = new FileHandler("origin-trace/origin-trace-" + month + ".txt", true);
            SimpleFormatter formatter = new SimpleFormatter(){

                @Override
                public String format(LogRecord record) {
                    String message = this.formatMessage(record);
                    return String.format("%s\t%s%s", dateFormat.format(new Date()), message, System.lineSeparator());
                }
            };
            fh.setFormatter(formatter);
            LOGGER.addHandler(fh);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    fh.close();
                }
            }));
        }
        catch (IOException e) {
            System.err.println("origin-tracer directory does not exist. Skipping origin traces...");
        }
    }
}

