/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.EndpointsOperationsImpl;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ServiceOperationsImpl
extends HasMetadataOperation<Service, ServiceList, DoneableService, Resource<Service, DoneableService>> {
    public ServiceOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public ServiceOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Service item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "services", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public Service replace(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.replace(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Service patch(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.patch(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Service waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        Service service = (Service)this.get();
        if (service == null) {
            throw new IllegalArgumentException("Service with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        EndpointsOperationsImpl endpointsOperation = new EndpointsOperationsImpl(this.client, this.config, this.apiVersion, this.getNamespace(), this.getName(), this.isCascading(), null, null, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
        Endpoints endpoints = endpointsOperation.waitUntilReady(amount, timeUnit);
        return (Service)this.get();
    }
}

