/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AutoValue_Recorder_Default;
import com.github.kristofa.brave.CurrentSpan;
import com.github.kristofa.brave.Recorder;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import zipkin.reporter.Reporter;

public abstract class AnnotationSubmitter {
    abstract CurrentSpan currentSpan();

    abstract Recorder recorder();

    public void submitAnnotation(String value) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return;
        }
        this.recorder().annotate(span, this.recorder().currentTimeMicroseconds(), value);
    }

    public void submitAnnotation(String value, long timestamp) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return;
        }
        this.recorder().annotate(span, timestamp, value);
    }

    void submitStartAnnotation(String startAnnotation) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return;
        }
        long timestamp = this.recorder().currentTimeMicroseconds();
        this.recorder().annotate(span, timestamp, startAnnotation);
        this.recorder().start(span, timestamp);
    }

    boolean submitEndAnnotation(String finishAnnotation) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return false;
        }
        long timestamp = this.recorder().currentTimeMicroseconds();
        this.recorder().annotate(span, timestamp, finishAnnotation);
        this.recorder().finish(span, timestamp);
        return true;
    }

    void submitAddress(String key, Endpoint endpoint) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return;
        }
        this.recorder().address(span, key, endpoint);
    }

    public void submitBinaryAnnotation(String key, String value) {
        Span span = this.currentSpan().get();
        if (span == null) {
            return;
        }
        this.recorder().tag(span, key, value);
    }

    @Deprecated
    public final void submitBinaryAnnotation(String key, int value) {
        this.submitBinaryAnnotation(key, String.valueOf(value));
    }

    AnnotationSubmitter() {
    }

    @Deprecated
    public static AnnotationSubmitter create(final SpanAndEndpoint spanAndEndpoint, Clock clock) {
        Util.checkNotNull(spanAndEndpoint, "Null spanAndEndpoint", new Object[0]);
        Util.checkNotNull(clock, "Null clock", new Object[0]);
        CurrentSpan currentSpan = new CurrentSpan(){

            @Override
            Span get() {
                return spanAndEndpoint.span();
            }
        };
        Endpoint localEndpoint = spanAndEndpoint.endpoint();
        AutoValue_Recorder_Default recorder = new AutoValue_Recorder_Default(localEndpoint, clock, (Reporter<zipkin.Span>)Reporter.NOOP);
        return AnnotationSubmitter.create(currentSpan, recorder);
    }

    static AnnotationSubmitter create(final CurrentSpan currentSpan, final Recorder recorder) {
        return new AnnotationSubmitter(){

            @Override
            CurrentSpan currentSpan() {
                return currentSpan;
            }

            @Override
            Recorder recorder() {
                return recorder;
            }
        };
    }

    static final class DefaultClock
    implements Clock {
        final long createTimestamp = System.currentTimeMillis() * 1000L;
        final long createTick = System.nanoTime();

        DefaultClock() {
        }

        @Override
        public long currentTimeMicroseconds() {
            return (System.nanoTime() - this.createTick) / 1000L + this.createTimestamp;
        }
    }

    public static interface Clock {
        public long currentTimeMicroseconds();
    }
}

