/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.DiscardingMessageHandler;
import org.springframework.integration.handler.MessageTriggerAction;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class BarrierMessageHandler
extends AbstractReplyProducingMessageHandler
implements MessageTriggerAction,
DiscardingMessageHandler {
    private final Map<Object, SynchronousQueue<Message<?>>> suspensions = new ConcurrentHashMap();
    private final ConcurrentMap<Object, Thread> inProcess = new ConcurrentHashMap<Object, Thread>();
    private final long timeout;
    private final CorrelationStrategy correlationStrategy;
    private final MessageGroupProcessor messageGroupProcessor;
    private volatile MessageChannel discardChannel;
    private String discardChannelName;

    public BarrierMessageHandler(long timeout) {
        this(timeout, new DefaultAggregatingMessageGroupProcessor());
    }

    public BarrierMessageHandler(long timeout, MessageGroupProcessor outputProcessor) {
        this(timeout, outputProcessor, new HeaderAttributeCorrelationStrategy("correlationId"));
    }

    public BarrierMessageHandler(long timeout, CorrelationStrategy correlationStrategy) {
        this(timeout, new DefaultAggregatingMessageGroupProcessor(), correlationStrategy);
    }

    public BarrierMessageHandler(long timeout, MessageGroupProcessor outputProcessor, CorrelationStrategy correlationStrategy) {
        Assert.notNull((Object)outputProcessor, (String)"'messageGroupProcessor' cannot be null");
        Assert.notNull((Object)correlationStrategy, (String)"'correlationStrategy' cannot be null");
        this.messageGroupProcessor = outputProcessor;
        this.correlationStrategy = correlationStrategy;
        this.timeout = timeout;
    }

    public void setDiscardChannelName(String discardChannelName) {
        this.discardChannelName = discardChannelName;
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    @Override
    public MessageChannel getDiscardChannel() {
        if (this.discardChannel == null && this.discardChannelName != null && this.getChannelResolver() != null) {
            this.discardChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.discardChannelName);
        }
        return this.discardChannel;
    }

    @Override
    public String getComponentType() {
        return "barrier";
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object key = this.correlationStrategy.getCorrelationKey(requestMessage);
        if (key == null) {
            throw new MessagingException(requestMessage, "Correlation Strategy returned null");
        }
        Thread existing = this.inProcess.putIfAbsent(key, Thread.currentThread());
        if (existing != null) {
            throw new MessagingException(requestMessage, "Correlation key (" + key + ") is already in use by " + existing.getName());
        }
        SynchronousQueue<Message<?>> syncQueue = this.createOrObtainQueue(key);
        try {
            Message<?> releaseMessage = syncQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (releaseMessage != null) {
                Object object = this.processRelease(key, requestMessage, releaseMessage);
                return object;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessageHandlingException(requestMessage, "Interrupted while waiting for release", (Throwable)e);
        }
        finally {
            this.inProcess.remove(key);
            this.suspensions.remove(key);
        }
        return null;
    }

    private Object processRelease(Object key, Message<?> requestMessage, Message<?> releaseMessage) {
        this.suspensions.remove(key);
        if (releaseMessage.getPayload() instanceof Throwable) {
            throw new MessagingException(requestMessage, "Releasing flow returned a throwable", (Throwable)releaseMessage.getPayload());
        }
        return this.buildResult(key, requestMessage, releaseMessage);
    }

    protected Object buildResult(Object key, Message<?> requestMessage, Message<?> releaseMessage) {
        SimpleMessageGroup group = new SimpleMessageGroup(key);
        group.add(requestMessage);
        group.add(releaseMessage);
        return this.messageGroupProcessor.processMessageGroup(group);
    }

    private SynchronousQueue<Message<?>> createOrObtainQueue(Object key) {
        SynchronousQueue syncQueue = new SynchronousQueue();
        SynchronousQueue existing = this.suspensions.putIfAbsent(key, syncQueue);
        if (existing != null) {
            syncQueue = existing;
        }
        return syncQueue;
    }

    @Override
    public void trigger(Message<?> message) {
        Object key = this.correlationStrategy.getCorrelationKey(message);
        if (key == null) {
            throw new MessagingException(message, "Correlation Strategy returned null");
        }
        SynchronousQueue<Message<?>> syncQueue = this.createOrObtainQueue(key);
        try {
            if (!syncQueue.offer(message, this.timeout, TimeUnit.MILLISECONDS)) {
                this.logger.error((Object)("Suspending thread timed out or did not arrive within timeout for: " + message));
                this.suspensions.remove(key);
                if (this.getDiscardChannel() != null) {
                    this.messagingTemplate.send(this.getDiscardChannel(), message);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error((Object)("Interrupted while waiting for the suspending thread for: " + message));
            this.suspensions.remove(key);
        }
    }
}

