/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.support.management.SubscribableChannelManagement;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

public abstract class AbstractSubscribableChannel
extends AbstractMessageChannel
implements SubscribableChannel,
SubscribableChannelManagement {
    private final AtomicInteger handlerCounter = new AtomicInteger();

    @Override
    public int getSubscriberCount() {
        MessageDispatcher dispatcher = this.getRequiredDispatcher();
        if (dispatcher instanceof AbstractDispatcher) {
            return ((AbstractDispatcher)dispatcher).getHandlerCount();
        }
        return this.handlerCounter.get();
    }

    public boolean subscribe(MessageHandler handler) {
        MessageDispatcher dispatcher;
        boolean added = (dispatcher = this.getRequiredDispatcher()).addHandler(handler);
        this.adjustCounterIfNecessary(dispatcher, added ? 1 : 0);
        return added;
    }

    public boolean unsubscribe(MessageHandler handle) {
        MessageDispatcher dispatcher;
        boolean removed = (dispatcher = this.getRequiredDispatcher()).removeHandler(handle);
        this.adjustCounterIfNecessary(dispatcher, removed ? -1 : 0);
        return removed;
    }

    private void adjustCounterIfNecessary(MessageDispatcher dispatcher, int delta) {
        if (delta != 0) {
            int counter = 0;
            counter = dispatcher instanceof AbstractDispatcher ? ((AbstractDispatcher)dispatcher).getHandlerCount() : this.handlerCounter.addAndGet(delta);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Channel '" + this.getFullChannelName() + "' has " + counter + " subscriber(s)."));
            }
        }
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        try {
            return this.getRequiredDispatcher().dispatch(message);
        }
        catch (MessageDispatchingException e) {
            String description = e.getMessage() + " for channel '" + this.getFullChannelName() + "'.";
            throw new MessageDeliveryException(message, description, (Throwable)((Object)e));
        }
    }

    private MessageDispatcher getRequiredDispatcher() {
        MessageDispatcher dispatcher = this.getDispatcher();
        Assert.state((dispatcher != null ? 1 : 0) != 0, (String)"'dispatcher' must not be null");
        return dispatcher;
    }

    protected abstract MessageDispatcher getDispatcher();
}

