/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.codec.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.codec.Codec;
import org.springframework.util.Assert;

public abstract class AbstractKryoCodec
implements Codec {
    protected final KryoPool pool;

    protected AbstractKryoCodec() {
        KryoFactory factory = new KryoFactory(){

            public Kryo create() {
                Kryo kryo = new Kryo();
                AbstractKryoCodec.this.configureKryoInstance(kryo);
                return kryo;
            }
        };
        this.pool = new KryoPool.Builder(factory).softReferences().build();
    }

    @Override
    public void encode(final Object object, OutputStream outputStream) throws IOException {
        Assert.notNull((Object)object, (String)"cannot encode a null object");
        Assert.notNull((Object)outputStream, (String)"'outputSteam' cannot be null");
        final Output output = outputStream instanceof Output ? (Output)outputStream : new Output(outputStream);
        this.pool.run((KryoCallback)new KryoCallback<Object>(){

            public Object execute(Kryo kryo) {
                AbstractKryoCodec.this.doEncode(kryo, object, output);
                return Void.class;
            }
        });
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T decode(byte[] bytes, Class<T> type) throws IOException {
        Assert.notNull((Object)bytes, (String)"'bytes' cannot be null");
        Input input = new Input(bytes);
        try {
            T t = this.decode((InputStream)input, type);
            return t;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T decode(InputStream inputStream, final Class<T> type) throws IOException {
        Assert.notNull((Object)inputStream, (String)"'inputStream' cannot be null");
        Assert.notNull(type, (String)"'type' cannot be null");
        final Input input = inputStream instanceof Input ? (Input)inputStream : new Input(inputStream);
        Object result = null;
        try {
            result = this.pool.run(new KryoCallback<T>(){

                public T execute(Kryo kryo) {
                    return AbstractKryoCodec.this.doDecode(kryo, input, type);
                }
            });
        }
        finally {
            input.close();
        }
        return (T)result;
    }

    @Override
    public byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encode(object, bos);
        byte[] bytes = bos.toByteArray();
        bos.close();
        return bytes;
    }

    protected abstract void doEncode(Kryo var1, Object var2, Output var3);

    protected abstract <T> T doDecode(Kryo var1, Input var2, Class<T> var3);

    protected abstract void configureKryoInstance(Kryo var1);
}

