/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.BridgeFrom;
import org.springframework.integration.annotation.BridgeTo;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.Role;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.annotation.AggregatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.BridgeFromAnnotationPostProcessor;
import org.springframework.integration.config.annotation.BridgeToAnnotationPostProcessor;
import org.springframework.integration.config.annotation.FilterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.InboundChannelAdapterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.RouterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.ServiceActivatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.SplitterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.TransformerAnnotationPostProcessor;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.support.SmartLifecycleRoleController;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingAnnotationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors = new HashMap();
    private final MultiValueMap<String, String> lazyLifecycleRoles = new LinkedMultiValueMap();
    private ConfigurableListableBeanFactory beanFactory;
    private boolean requireComponentAnnotation;

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setRequireComponentAnnotation(boolean requireComponentAnnotation) {
        this.requireComponentAnnotation = requireComponentAnnotation;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        this.postProcessors.put(Filter.class, new FilterAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(Router.class, new RouterAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(Transformer.class, new TransformerAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(ServiceActivator.class, new ServiceActivatorAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(Splitter.class, new SplitterAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(Aggregator.class, new AggregatorAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(InboundChannelAdapter.class, new InboundChannelAdapterAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(BridgeFrom.class, new BridgeFromAnnotationPostProcessor(this.beanFactory));
        this.postProcessors.put(BridgeTo.class, new BridgeToAnnotationPostProcessor(this.beanFactory));
        Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> customPostProcessors = this.setupCustomPostProcessors();
        if (!CollectionUtils.isEmpty(customPostProcessors)) {
            this.postProcessors.putAll(customPostProcessors);
        }
    }

    protected Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> setupCustomPostProcessors() {
        return null;
    }

    public <A extends Annotation> void addMessagingAnnotationPostProcessor(Class<A> annotation, MethodAnnotationPostProcessor<A> postProcessor) {
        this.postProcessors.put(annotation, postProcessor);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void afterSingletonsInstantiated() {
        try {
            SmartLifecycleRoleController roleController = (SmartLifecycleRoleController)this.beanFactory.getBean("integrationLifecycleRoleController", SmartLifecycleRoleController.class);
            for (Map.Entry entry : this.lazyLifecycleRoles.entrySet()) {
                roleController.addLifecyclesToRole((String)entry.getKey(), (List)entry.getValue());
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.error((Object)"No LifecycleRoleController in the context");
        }
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        Class<?> beanClass = this.getBeanClass(bean);
        if (this.requireComponentAnnotation && AnnotationUtils.findAnnotation(beanClass, Component.class) == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                HashMap<Class, List<Annotation>> annotationChains = new HashMap<Class, List<Annotation>>();
                for (Class clazz : MessagingAnnotationPostProcessor.this.postProcessors.keySet()) {
                    List<Annotation> annotationChain;
                    if (!AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)clazz.getName()) || (annotationChain = MessagingAnnotationPostProcessor.this.getAnnotationChain(method, clazz)).size() <= 0) continue;
                    annotationChains.put(clazz, annotationChain);
                }
                for (Map.Entry entry : annotationChains.entrySet()) {
                    Class annotationType = (Class)entry.getKey();
                    List annotations = (List)entry.getValue();
                    MessagingAnnotationPostProcessor.this.processAnnotationTypeOnMethod(bean, beanName, method, annotationType, annotations);
                }
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }

    protected void processAnnotationTypeOnMethod(Object bean, String beanName, Method method, Class<? extends Annotation> annotationType, List<Annotation> annotations) {
        MethodAnnotationPostProcessor<?> postProcessor = this.postProcessors.get(annotationType);
        if (postProcessor != null && postProcessor.shouldCreateEndpoint(method, annotations)) {
            Object result;
            Method targetMethod = method;
            if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                try {
                    targetMethod = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Service methods must be extracted to the service interface for JdkDynamicProxy. The affected bean is: '" + beanName + "' and its method: '" + method + "'", e);
                }
            }
            if ((result = postProcessor.postProcess(bean, beanName, targetMethod, annotations)) != null && result instanceof AbstractEndpoint) {
                String phase;
                AbstractEndpoint endpoint = (AbstractEndpoint)result;
                String autoStartup = MessagingAnnotationUtils.resolveAttribute(annotations, "autoStartup", String.class);
                if (StringUtils.hasText((String)autoStartup) && StringUtils.hasText((String)(autoStartup = this.getBeanFactory().resolveEmbeddedValue(autoStartup)))) {
                    endpoint.setAutoStartup(Boolean.parseBoolean(autoStartup));
                }
                if (StringUtils.hasText((String)(phase = MessagingAnnotationUtils.resolveAttribute(annotations, "phase", String.class))) && StringUtils.hasText((String)(phase = this.getBeanFactory().resolveEmbeddedValue(phase)))) {
                    endpoint.setPhase(Integer.parseInt(phase));
                }
                String endpointBeanName = this.generateBeanName(beanName, method, annotationType);
                endpoint.setBeanName(endpointBeanName);
                this.getBeanFactory().registerSingleton(endpointBeanName, (Object)endpoint);
                this.getBeanFactory().initializeBean((Object)endpoint, endpointBeanName);
                Role role = (Role)AnnotationUtils.findAnnotation((Method)method, Role.class);
                if (role != null) {
                    this.lazyLifecycleRoles.add((Object)role.value(), (Object)endpointBeanName);
                }
            }
        }
    }

    protected List<Annotation> getAnnotationChain(Method method, Class<? extends Annotation> annotationType) {
        Annotation[] annotations = AnnotationUtils.getAnnotations((Method)method);
        LinkedList<Annotation> annotationChain = new LinkedList<Annotation>();
        HashSet<Annotation> visited = new HashSet<Annotation>();
        for (Annotation ann : annotations) {
            this.recursiveFindAnnotation(annotationType, ann, annotationChain, visited);
            if (annotationChain.size() <= 0) continue;
            Collections.reverse(annotationChain);
            return annotationChain;
        }
        return annotationChain;
    }

    protected boolean recursiveFindAnnotation(Class<? extends Annotation> annotationType, Annotation ann, List<Annotation> annotationChain, Set<Annotation> visited) {
        if (ann.annotationType().equals(annotationType)) {
            annotationChain.add(ann);
            return true;
        }
        for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
            if (ann.equals(metaAnn) || visited.contains(metaAnn) || metaAnn.annotationType().getPackage().getName().startsWith("java.lang")) continue;
            visited.add(metaAnn);
            if (!this.recursiveFindAnnotation(annotationType, metaAnn, annotationChain, visited)) continue;
            annotationChain.add(ann);
            return true;
        }
        return false;
    }

    protected Class<?> getBeanClass(Object bean) {
        Class<?> targetClass = AopUtils.getTargetClass((Object)bean);
        return targetClass != null ? targetClass : bean.getClass();
    }

    protected String generateBeanName(String originalBeanName, Method method, Class<? extends Annotation> annotationType) {
        String baseName;
        String name = baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(annotationType);
        int count = 1;
        while (this.beanFactory.containsBean(name)) {
            name = baseName + "#" + ++count;
        }
        return name;
    }

    protected Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> getPostProcessors() {
        return this.postProcessors;
    }

    protected MultiValueMap<String, String> getLazyLifecycleRoles() {
        return this.lazyLifecycleRoles;
    }
}

