/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ClassUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(8);

    public static Class<?> findClosestMatch(Class<?> type, Set<Class<?>> candidates, boolean failOnTie) {
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Class<?> closestMatch = null;
        for (Class<?> candidate : candidates) {
            int typeDiffWeight = ClassUtils.getTypeDifferenceWeight(candidate, type);
            if (typeDiffWeight < minTypeDiffWeight) {
                minTypeDiffWeight = typeDiffWeight;
                closestMatch = candidate;
                continue;
            }
            if (!failOnTie || typeDiffWeight >= Integer.MAX_VALUE || typeDiffWeight != minTypeDiffWeight) continue;
            throw new IllegalStateException("Unresolvable ambiguity while attempting to find closest match for [" + type.getName() + "]. Candidate types [" + closestMatch.getName() + "] and [" + candidate.getName() + "] have equal weight.");
        }
        return closestMatch;
    }

    private static int getTypeDifferenceWeight(Class<?> candidate, Class<?> type) {
        int result = 0;
        if (!org.springframework.util.ClassUtils.isAssignable(candidate, type)) {
            return Integer.MAX_VALUE;
        }
        Class<?> superClass = type.getSuperclass();
        while (superClass != null) {
            if (type.equals(superClass)) {
                result += 2;
                superClass = null;
                continue;
            }
            if (org.springframework.util.ClassUtils.isAssignable(candidate, superClass)) {
                result += 2;
                superClass = superClass.getSuperclass();
                continue;
            }
            superClass = null;
        }
        if (candidate.isInterface()) {
            ++result;
        }
        return result;
    }

    public static Class<?> resolvePrimitiveType(Class<?> clazz) {
        return primitiveWrapperTypeMap.get(clazz);
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
    }
}

