/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.deployment.CamelIntegrationParser;
import org.wildfly.extension.camel.handler.NamingContextAssociationHandler;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelContextBindingService;
import org.wildfly.extension.camel.service.CamelContextFactoryBindingService;
import org.wildfly.extension.camel.service.CamelContextRegistryBindingService;

public class CamelCoreSubsystemExtension
implements CamelSubsytemExtension {
    private final Map<CamelContext, ServiceController<?>> contexts = new HashMap();

    @Override
    public void addExtensionServices(ServiceTarget serviceTarget, SubsystemState subsystemState) {
        CamelContextFactoryBindingService.addService(serviceTarget);
        CamelContextRegistryBindingService.addService(serviceTarget);
    }

    @Override
    public void addDeploymentProcessor(DeploymentProcessorTarget processorTarget, SubsystemState subsystemState) {
        JBossAllXmlParserRegisteringProcessor parser = new JBossAllXmlParserRegisteringProcessor(CamelIntegrationParser.ROOT_ELEMENT, CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY, (JBossAllXMLParser)new CamelIntegrationParser());
        processorTarget.addDeploymentProcessor("camel", Phase.STRUCTURE, 2783, (DeploymentUnitProcessor)parser);
    }

    @Override
    public ContextCreateHandler getContextCreateHandler(ServiceContainer serviceContainer, ServiceTarget serviceTarget, SubsystemState subsystemState) {
        return new NamingContextAssociationHandler(serviceContainer, serviceTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCamelContext(ServiceTarget serviceTarget, CamelContext camelctx) {
        ServiceController<?> controller = CamelContextBindingService.addService(serviceTarget, camelctx);
        Map<CamelContext, ServiceController<?>> map = this.contexts;
        synchronized (map) {
            this.contexts.put(camelctx, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCamelContext(CamelContext camelctx) {
        ServiceController<?> controller;
        Map<CamelContext, ServiceController<?>> map = this.contexts;
        synchronized (map) {
            controller = this.contexts.get(camelctx);
            this.contexts.remove(camelctx);
        }
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

