/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public class CamelContextDescriptorsProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String runtimeName = depUnit.getName();
        CamelDeploymentSettings.Builder depSettings = (CamelDeploymentSettings.Builder)depUnit.getAttachment(CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY);
        if (depSettings.isDisabledByJbossAll() || !depSettings.isDeploymentValid() || runtimeName.endsWith(".ear")) {
            return;
        }
        try {
            boolean addedAny = false;
            if (runtimeName.endsWith("camel-context.xml")) {
                URL fileURL = ((VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS)).asFileURL();
                addedAny |= this.addConditionally(depUnit, depSettings, fileURL);
            } else {
                VirtualFileFilter filter = new VirtualFileFilter(){

                    public boolean accepts(VirtualFile child) {
                        return child.isFile() && child.getName().endsWith("camel-context.xml");
                    }
                };
                VirtualFile rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                for (VirtualFile vfile : rootFile.getChildrenRecursively(filter)) {
                    addedAny |= this.addConditionally(depUnit, depSettings, vfile.asFileURL());
                }
            }
            if (addedAny) {
                CamelLogger.LOGGER.info("Camel context descriptors found");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create camel context: " + runtimeName, ex);
        }
    }

    public boolean addConditionally(DeploymentUnit depUnit, CamelDeploymentSettings.Builder depSettingsBuilder, URL fileURL) {
        boolean skipResource = false;
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (AnnotationInstance aninst : index.getAnnotations(DotName.createSimple((String)"org.apache.camel.cdi.ImportResource"))) {
            for (String resname : aninst.value().asStringArray()) {
                skipResource |= fileURL.getPath().endsWith(resname);
            }
        }
        if (!skipResource) {
            depSettingsBuilder.camelContextUrl(fileURL);
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

