/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.service.CamelEndpointDeployerService;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;

public class CamelEndpointDeployerProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)deploymentUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (!depSettings.isEnabled()) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            CamelLogger.LOGGER.debug("{} ignores non-WAR deployment {}", (Object)CamelEndpointDeployerProcessor.class.getSimpleName(), (Object)deploymentUnit.getName());
            return;
        }
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        ModelNode node = deploymentResourceSupport.getDeploymentSubsystemModel("undertow");
        String hostName = node.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
        String serverName = node.get(DeploymentDefinition.SERVER.getName()).asString();
        String path = node.get(DeploymentDefinition.CONTEXT_ROOT.getName()).asString();
        ServiceName deploymentServiceName = UndertowService.deploymentServiceName((String)serverName, (String)hostName, (String)path);
        ServiceName deploymentInfoServiceName = deploymentServiceName.append(UndertowDeploymentInfoService.SERVICE_NAME);
        ServiceName hostServiceName = UndertowService.virtualHostName((String)serverName, (String)hostName);
        CamelEndpointDeployerService.addService(deploymentUnit, phaseContext.getServiceTarget(), deploymentInfoServiceName, hostServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

